if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface SuspensionButton_Params {
    isOpen?: boolean;
    logString?: string;
}
import type promptAction from "@ohos:promptAction";
import { ComponentContent as ComponentContent } from "@ohos:arkui.node";
import router from "@ohos:router";
import type window from "@ohos:window";
import emitter from "@ohos:events.emitter";
import type { Callback as Callback } from "@ohos:base";
import display from "@ohos:display";
import { CLOpenDialogManager } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLOpenDialogManager&";
import type { CLDialogSize, CLLoginDialogOptions } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLOpenDialogManager&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/CLLogPage&";
import { CLLogPage } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLLogPage&";
import type common from "@ohos:app.ability.common";
export interface LogItem {
    level: string;
    message: string;
    timestamp: string;
    id: string;
}
export class CLLogCache {
    private static logs: LogItem[] = [];
    /** 添加一条日志 */
    static addLog(log: LogItem) {
        CLLogCache.logs.push(log);
        if (CLLogCache.logs.length > 200)
            CLLogCache.logs.shift(); // 限制最多200条
    }
    /** 获取所有日志 */
    static getLogs(): LogItem[] {
        return CLLogCache.logs;
    }
    /** 清空日志 */
    static clear() {
        CLLogCache.logs = [];
    }
}
export class CLLogReceiver {
    // private static _eventId: number = 0x11110001
    private static _eventId: number = 34;
    private static _callback: ((log: LogItem) => void) | null = null;
    private static _subscription: Callback<emitter.EventData> | null = null;
    static startListening(callback: (log: LogItem) => void) {
        CLLogReceiver._callback = callback;
        if (CLLogReceiver._subscription)
            return; // 已经监听过了
        let event: emitter.InnerEvent = {
            eventId: CLLogReceiver._eventId
        };
        let callback1: Callback<emitter.EventData> = (eventData: emitter.EventData) => {
            const payload = eventData?.data as LogItem;
            if (payload && CLLogReceiver._callback) {
                CLLogCache.addLog(payload);
                CLLogReceiver._callback(payload);
            }
        };
        emitter.on(event, callback1);
    }
    static sendMsg(msg: string) {
        emitter.emit('34', { priority: emitter.EventPriority.LOW }, { data: { "key": '还有谁' } });
    }
    static stopListening() {
        if (CLLogReceiver._subscription) {
            emitter.off(CLLogReceiver._eventId, CLLogReceiver._subscription);
            CLLogReceiver._subscription = null;
        }
    }
}
function getLogBuilder(size: CLDialogSize, parent = null) {
    const __size__ = size;
    (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender, size = __size__) => {
        __Common__.create();
        __Common__.width(size.width);
        __Common__.height(size.height);
    }, __Common__);
    {
        (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender, size = __size__) => {
            if (isInitialRender) {
                let componentCall = new CLLogPage(parent ? parent : this, {}, undefined, elmtId, () => { }, { page: "RealAuthDemo/src/main/ets/common/CLCoreLog.ets", line: 84, col: 3 });
                ViewPU.create(componentCall);
                let paramsLambda = () => {
                    return {};
                };
                componentCall.paramsGenerator_ = paramsLambda;
            }
            else {
                (parent ? parent : this).updateStateVarsOfChildByElmtId(elmtId, {});
            }
        }, { name: "CLLogPage" });
    }
    __Common__.pop();
}
function getLogButtonBuilder(parent = null) {
    (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender) => {
        __Common__.create();
        __Common__.width(60);
        __Common__.height(60);
    }, __Common__);
    {
        (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender) => {
            if (isInitialRender) {
                let componentCall = new SuspensionButton(parent ? parent : this, {}, undefined, elmtId, () => { }, { page: "RealAuthDemo/src/main/ets/common/CLCoreLog.ets", line: 91, col: 3 });
                ViewPU.create(componentCall);
                let paramsLambda = () => {
                    return {};
                };
                componentCall.paramsGenerator_ = paramsLambda;
            }
            else {
                (parent ? parent : this).updateStateVarsOfChildByElmtId(elmtId, {});
            }
        }, { name: "SuspensionButton" });
    }
    __Common__.pop();
}
export class CLLogManager {
    screenWidth: number = 0;
    screenHeight: number = 0;
    static isOpen: boolean = false;
    static currentSubWindow: window.Window | null = null;
    static isMinimized: boolean = false; // 当前子窗口是否缩小
    static setLogButton() {
        let builder = wrapBuilder(getLogButtonBuilder) as WrappedBuilder<[
        ]>;
        let context = getContext() as common.UIAbilityContext;
        let uiContext = context.windowStage.getMainWindowSync().getUIContext();
        let screenWidth = display.getDefaultDisplaySync().width;
        let dialogOptions: promptAction.BaseDialogOptions = {
            autoCancel: false,
            isModal: false,
            maskColor: Color.Transparent,
            alignment: DialogAlignment.TopEnd,
            offset: { dx: -30, dy: 40 },
            showInSubWindow: true,
            onWillDismiss: (dississAction) => {
                if (DismissReason.PRESS_BACK === dississAction.reason) {
                    router.back();
                }
            }
        };
        let node = new ComponentContent(uiContext, builder);
        uiContext.getPromptAction().openCustomDialog(node, dialogOptions);
    }
    static showLogView() {
        if (CLLogManager.isOpen) {
            return;
        }
        CLLogManager.isOpen = true;
        let builder = wrapBuilder(getLogBuilder) as WrappedBuilder<[
        ]>;
        let context = getContext() as common.UIAbilityContext;
        let uiContext = context.windowStage.getMainWindowSync().getUIContext();
        let dialogOptions: CLLoginDialogOptions = {
            width: '100%',
            height: '40%',
            autoCancel: false,
            isModal: false,
            maskColor: Color.Transparent,
            alignment: DialogAlignment.Top,
            onWillDismiss: (dississAction) => {
                if (DismissReason.PRESS_BACK === dississAction.reason) {
                    router.back();
                }
            }
        };
        CLOpenDialogManager.openDialogController(builder, uiContext, dialogOptions);
    }
    static hideLogView() {
        CLLogManager.isOpen = false;
        CLOpenDialogManager.closeDialogController();
    }
}
class SuspensionButton extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__isOpen = new ObservedPropertySimplePU(true, this, "isOpen");
        this.__logString = new ObservedPropertySimplePU('关闭', this, "logString");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: SuspensionButton_Params) {
        if (params.isOpen !== undefined) {
            this.isOpen = params.isOpen;
        }
        if (params.logString !== undefined) {
            this.logString = params.logString;
        }
    }
    updateStateVars(params: SuspensionButton_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__isOpen.purgeDependencyOnElmtId(rmElmtId);
        this.__logString.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__isOpen.aboutToBeDeleted();
        this.__logString.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __isOpen: ObservedPropertySimplePU<boolean>;
    get isOpen() {
        return this.__isOpen.get();
    }
    set isOpen(newValue: boolean) {
        this.__isOpen.set(newValue);
    }
    private __logString: ObservedPropertySimplePU<string>;
    get logString() {
        return this.__logString.get();
    }
    set logString(newValue: string) {
        this.__logString.set(newValue);
    }
    aboutToAppear() {
    }
    onBackPress(): boolean | void {
        return;
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create({ alignContent: Alignment.TopStart });
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.width('100%');
            Blank.height('100%');
        }, Blank);
        Blank.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.logString);
            Button.backgroundColor('#007AFF');
            Button.fontColor('#fff');
            Button.borderRadius(30);
            Button.width(60);
            Button.height(60);
            Button.onClick(() => {
                this.isOpen = !this.isOpen;
                if (this.isOpen) {
                    this.logString = '关闭';
                    CLLogManager.showLogView();
                }
                else {
                    this.logString = '打开';
                    CLLogManager.hideLogView();
                }
            });
        }, Button);
        Button.pop();
        Stack.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "SuspensionButton";
    }
}
registerNamedRoute(() => new SuspensionButton(undefined, {}), "", { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "common/CLCoreLog", pageFullPath: "RealAuthDemo/src/main/ets/common/CLCoreLog", integratedHsp: "false", moduleType: "followWithHap" });
