if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface LoadingDialogUI_Params {
}
import type { BusinessError as BusinessError } from "@ohos:base";
import { ComponentContent as ComponentContent } from "@ohos:arkui.node";
import type promptAction from "@ohos:promptAction";
import type { UIContext as UIContext } from "@ohos:arkui.UIContext";
class LoadingDialogUI extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: LoadingDialogUI_Params) {
    }
    updateStateVars(params: LoadingDialogUI_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
    }
    aboutToBeDeleted() {
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 10 });
            Column.padding(20);
            Column.backgroundColor(Color.White);
            Column.borderRadius(12);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 菊花 Progress
            LoadingProgress.create();
            // 菊花 Progress
            LoadingProgress.width(40);
            // 菊花 Progress
            LoadingProgress.height(40);
        }, LoadingProgress);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create("加载中...");
            Text.fontSize(16);
            Text.fontColor(Color.Black);
        }, Text);
        Text.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
}
function MessageDialogBuilder(label?: string, parent = null) {
    const __label__ = label;
    (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender, label = __label__) => {
        Column.create({ space: 10 });
        Column.padding(20);
        Column.backgroundColor(Color.White);
        Column.borderRadius(12);
    }, Column);
    (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender, label = __label__) => {
        // 菊花 Progress
        LoadingProgress.create();
        // 菊花 Progress
        LoadingProgress.width(40);
        // 菊花 Progress
        LoadingProgress.height(40);
    }, LoadingProgress);
    (parent ? parent : this).observeComponentCreation2((elmtId, isInitialRender, label = __label__) => {
        Text.create("加载中...");
        Text.fontSize(16);
        Text.fontColor(Color.Black);
    }, Text);
    Text.pop();
    Column.pop();
}
export class CLToast {
    private static ctx: UIContext;
    static options: promptAction.BaseDialogOptions;
    static contentNode: ComponentContent<Object>;
    static showMessage(ctx: UIContext, message: string) {
        ctx.getPromptAction().showToast({
            message: message,
            alignment: Alignment.Center
        });
    }
    static setDialogOptions(options: promptAction.BaseDialogOptions) {
        CLToast.options = options;
    }
    private static setDefaultDialogOptions() {
        CLToast.options = {
            autoCancel: false
        };
    }
    static showLoading(ctx: UIContext) {
        CLToast.setDefaultDialogOptions();
        CLToast.contentNode = new ComponentContent(ctx, wrapBuilder(MessageDialogBuilder));
        CLToast.ctx = ctx;
        ctx.getPromptAction().openCustomDialog(CLToast.contentNode, CLToast.options)
            .then(() => {
        }).catch((error: BusinessError) => {
            let message = (error as BusinessError).message;
            let code = (error as BusinessError).code;
            console.error(`CloseCustomDialog args error code is ${code}, message is ${message}`);
        });
    }
    static hideHud() {
        if (CLToast.contentNode !== null) {
            CLToast.ctx.getPromptAction().closeCustomDialog(CLToast.contentNode)
                .then(() => {
            }).catch((error: BusinessError) => {
                let message = (error as BusinessError).message;
                let code = (error as BusinessError).code;
                console.error(`CloseCustomDialog args error code is ${code}, message is ${message}`);
            });
        }
    }
}
export class CLHud {
    static ctx: UIContext;
    static contentNode: ComponentContent<Object>;
    static options: promptAction.BaseDialogOptions;
    static setContext(context: UIContext) {
        CLHud.ctx = context;
    }
    static setContentNode(contentNode: ComponentContent<Object>) {
        CLHud.contentNode = contentNode;
    }
    static setOptions(options: promptAction.BaseDialogOptions) {
        CLHud.options = options;
    }
    static openDialog() {
        if (CLHud.contentNode !== null) {
            CLHud.ctx.getPromptAction().openCustomDialog(CLHud.contentNode, CLHud.options)
                .then(() => {
                console.log('打开');
            }).catch((error: BusinessError) => {
                let message = (error as BusinessError).message;
                let code = (error as BusinessError).code;
                console.error(`OpenCustomDialog args error code is ${code}, message is ${message}`);
            });
        }
    }
    static closeDialog() {
        if (CLHud.contentNode !== null) {
            CLHud.ctx.getPromptAction().closeCustomDialog(CLHud.contentNode)
                .then(() => {
                console.info('CloseCustomDialog complete.');
            })
                .catch((error: BusinessError) => {
                let message = (error as BusinessError).message;
                let code = (error as BusinessError).code;
                console.error(`CloseCustomDialog args error code is ${code}, message is ${message}`);
            });
        }
    }
    static updateDialog(options: promptAction.BaseDialogOptions) {
        if (CLHud.contentNode !== null) {
            CLHud.ctx.getPromptAction().updateCustomDialog(CLHud.contentNode, options)
                .then(() => {
                console.info('UpdateCustomDialog complete.');
            })
                .catch((error: BusinessError) => {
                let message = (error as BusinessError).message;
                let code = (error as BusinessError).code;
                console.error(`UpdateCustomDialog args error code is ${code}, message is ${message}`);
            });
        }
    }
}
