import type promptAction from "@ohos:promptAction";
import { ComponentContent as ComponentContent } from "@ohos:arkui.node";
import type { BusinessError as BusinessError } from "@ohos:base";
export interface CLDialogSize {
    width: Length | undefined;
    height: Length | undefined;
}
export interface CLLoginDialogOptions extends promptAction.BaseDialogOptions {
    width?: Length;
    height?: Length;
}
export class CLOpenDialogManager {
    private static ctx: UIContext;
    static options: promptAction.BaseDialogOptions;
    static contentNode: ComponentContent<Object>;
    static showMessage(ctx: UIContext, message: string) {
        ctx.getPromptAction().showToast({
            message: message,
            alignment: Alignment.Center
        });
    }
    static setDialogOptions(options: promptAction.BaseDialogOptions) {
        CLOpenDialogManager.options = options;
    }
    private static setDefaultDialogOptions() {
        CLOpenDialogManager.options = {
            autoCancel: false
        };
    }
    static openDialogController(builder: WrappedBuilder<[
    ]>, ctx: UIContext, options?: CLLoginDialogOptions) {
        let size: CLDialogSize = {
            width: options?.width,
            height: options?.height
        };
        CLOpenDialogManager.contentNode = new ComponentContent(ctx, builder, size);
        CLOpenDialogManager.ctx = ctx;
        ctx.getPromptAction().openCustomDialog(CLOpenDialogManager.contentNode, options)
            .then(() => {
        }).catch((error: BusinessError) => {
            let message = (error as BusinessError).message;
            let code = (error as BusinessError).code;
            console.error(`CloseCustomDialog args error code is ${code}, message is ${message}`);
        });
    }
    static closeDialogController() {
        if (CLOpenDialogManager.contentNode !== null) {
            CLOpenDialogManager.ctx.getPromptAction().closeCustomDialog(CLOpenDialogManager.contentNode)
                .then(() => {
            }).catch((error: BusinessError) => {
                let message = (error as BusinessError).message;
                let code = (error as BusinessError).code;
                console.error(`CloseCustomDialog args error code is ${code}, message is ${message}`);
            });
        }
    }
}
