import http from "@ohos:net.http";
import type { BusinessError as BusinessError } from "@ohos:base";
export class CLResponse {
    code: string = '000000';
    message: string = '';
    data?: CLReponseToken;
}
export class CLReponseToken {
    authToken: string = '';
}
export class CLRequest {
    public static generateRandomString(length: number): string {
        return new Array(length)
            .fill(0)
            .map(() => Math.floor(Math.random() * 36).toString(36))
            .join('');
    }
    static async request(url: string, appkey: string, appSecret: string): Promise<any> {
        let request = http.createHttp();
        try {
            let result = await request.request(url, {
                method: http.RequestMethod.POST,
                header: { 'Content-Type': 'application/json' },
                extraData: {
                    'appKey': appkey,
                    'appSecret': appSecret,
                    'did': CLRequest.generateRandomString(32)
                }
            });
            if (result.responseCode == http.ResponseCode.OK) {
                const map: CLResponse = JSON.parse(result.result.toString());
                return map;
            }
            return { 'code': '778899', message: '请求异常' } as CLResponse;
        }
        catch (e) {
            let error = e as BusinessError;
            console.log(`请求异常：error code = ${error.code} ,error message = ${error.message}`);
            return { 'code': `${error.code}`, message: `${error.message}` } as CLResponse;
            return error;
        }
    }
}
