import hilog from "@ohos:hilog";
import emitter from "@ohos:events.emitter";
const TAG = 'cameraDemo';
class Logger {
    private domain: number;
    private prefix: string;
    private format: string = '%{public}s';
    constructor(prefix: string) {
        this.prefix = prefix;
        this.domain = 0x1111;
    }
    private static _emit(level: string, msg: string) {
        let payload: any = {
            level,
            message: msg,
            timestamp: new Date().toISOString(),
        };
        let event: emitter.InnerEvent = {
            eventId: 34,
            priority: emitter.EventPriority.LOW
        };
        let eventData: emitter.EventData = {
            data: payload
        };
        // 发送eventId为1的事件，事件内容为eventData。
        emitter.emit(event, eventData);
    }
    debug(args: string): void {
        Logger._emit('DEBUG', args);
        hilog.debug(this.domain, this.prefix, this.format, args);
    }
    info(args: string): void {
        Logger._emit('INFO', args);
        hilog.info(this.domain, this.prefix, this.format, args);
    }
    warn(args: string): void {
        Logger._emit('WARN', args);
        hilog.warn(this.domain, this.prefix, this.format, args);
    }
    error(args: string): void {
        Logger._emit('ERROR', args);
        hilog.error(this.domain, this.prefix, this.format, args);
    }
}
export default new Logger(TAG);
