if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLLivingVideoPage_Params {
    remainTime?: number;
    totalTime?: number;
    isRunning?: boolean;
    intervalId?: number | null;
    mucImageState?: boolean;
    mucImageName?: Resource;
    actImageName?: string;
    tipString?: string;
    currentImage?: string;
    translateY?: number;
    isMoving?: boolean;
    context?: Context;
    mXComponentController?: XComponentController;
    surfaceId?: string;
    permissions?: Array<Permissions>;
}
import { CLAVPlayer } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLAVPlayer&";
import { CLRealPersonManager, CLStatus } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import type { CLTypeParamObject } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import type { Permissions } from "@ohos:abilityAccessCtrl";
import JSON from "@ohos:util.json";
import promptAction from "@ohos:promptAction";
import router from "@ohos:router";
import Logger from "@normalized:N&&&realauthdemo/src/main/ets/common/Logger&";
export class CLLivingVideoPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__remainTime = new ObservedPropertySimplePU(30, this, "remainTime");
        this.__totalTime = new ObservedPropertySimplePU(30, this, "totalTime");
        this.__isRunning = new ObservedPropertySimplePU(false, this, "isRunning");
        this.intervalId = null;
        this.__mucImageState = new ObservedPropertySimplePU(true, this, "mucImageState");
        this.__mucImageName = new ObservedPropertyObjectPU({ "id": 16777262, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, this, "mucImageName");
        this.__actImageName = new ObservedPropertySimplePU('', this, "actImageName");
        this.__tipString = new ObservedPropertySimplePU('请面向屏幕', this, "tipString");
        this.__currentImage = new ObservedPropertySimplePU('', this, "currentImage");
        this.__translateY = new ObservedPropertySimplePU(-150, this, "translateY");
        this.__isMoving = new ObservedPropertySimplePU(false, this, "isMoving");
        this.__context = new ObservedPropertyObjectPU(this.getUIContext().getHostContext()!, this, "context");
        this.mXComponentController = new XComponentController;
        this.__surfaceId = new ObservedPropertySimplePU('', this, "surfaceId");
        this.permissions = [
            'ohos.permission.CAMERA',
            'ohos.permission.MICROPHONE',
            'ohos.permission.MEDIA_LOCATION',
            'ohos.permission.READ_IMAGEVIDEO',
            'ohos.permission.WRITE_IMAGEVIDEO',
        ];
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLLivingVideoPage_Params) {
        if (params.remainTime !== undefined) {
            this.remainTime = params.remainTime;
        }
        if (params.totalTime !== undefined) {
            this.totalTime = params.totalTime;
        }
        if (params.isRunning !== undefined) {
            this.isRunning = params.isRunning;
        }
        if (params.intervalId !== undefined) {
            this.intervalId = params.intervalId;
        }
        if (params.mucImageState !== undefined) {
            this.mucImageState = params.mucImageState;
        }
        if (params.mucImageName !== undefined) {
            this.mucImageName = params.mucImageName;
        }
        if (params.actImageName !== undefined) {
            this.actImageName = params.actImageName;
        }
        if (params.tipString !== undefined) {
            this.tipString = params.tipString;
        }
        if (params.currentImage !== undefined) {
            this.currentImage = params.currentImage;
        }
        if (params.translateY !== undefined) {
            this.translateY = params.translateY;
        }
        if (params.isMoving !== undefined) {
            this.isMoving = params.isMoving;
        }
        if (params.context !== undefined) {
            this.context = params.context;
        }
        if (params.mXComponentController !== undefined) {
            this.mXComponentController = params.mXComponentController;
        }
        if (params.surfaceId !== undefined) {
            this.surfaceId = params.surfaceId;
        }
        if (params.permissions !== undefined) {
            this.permissions = params.permissions;
        }
    }
    updateStateVars(params: CLLivingVideoPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__remainTime.purgeDependencyOnElmtId(rmElmtId);
        this.__totalTime.purgeDependencyOnElmtId(rmElmtId);
        this.__isRunning.purgeDependencyOnElmtId(rmElmtId);
        this.__mucImageState.purgeDependencyOnElmtId(rmElmtId);
        this.__mucImageName.purgeDependencyOnElmtId(rmElmtId);
        this.__actImageName.purgeDependencyOnElmtId(rmElmtId);
        this.__tipString.purgeDependencyOnElmtId(rmElmtId);
        this.__currentImage.purgeDependencyOnElmtId(rmElmtId);
        this.__translateY.purgeDependencyOnElmtId(rmElmtId);
        this.__isMoving.purgeDependencyOnElmtId(rmElmtId);
        this.__context.purgeDependencyOnElmtId(rmElmtId);
        this.__surfaceId.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__remainTime.aboutToBeDeleted();
        this.__totalTime.aboutToBeDeleted();
        this.__isRunning.aboutToBeDeleted();
        this.__mucImageState.aboutToBeDeleted();
        this.__mucImageName.aboutToBeDeleted();
        this.__actImageName.aboutToBeDeleted();
        this.__tipString.aboutToBeDeleted();
        this.__currentImage.aboutToBeDeleted();
        this.__translateY.aboutToBeDeleted();
        this.__isMoving.aboutToBeDeleted();
        this.__context.aboutToBeDeleted();
        this.__surfaceId.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __remainTime: ObservedPropertySimplePU<number>;
    get remainTime() {
        return this.__remainTime.get();
    }
    set remainTime(newValue: number) {
        this.__remainTime.set(newValue);
    }
    private __totalTime: ObservedPropertySimplePU<number>;
    get totalTime() {
        return this.__totalTime.get();
    }
    set totalTime(newValue: number) {
        this.__totalTime.set(newValue);
    }
    private __isRunning: ObservedPropertySimplePU<boolean>;
    get isRunning() {
        return this.__isRunning.get();
    }
    set isRunning(newValue: boolean) {
        this.__isRunning.set(newValue);
    }
    private intervalId: number | null;
    private __mucImageState: ObservedPropertySimplePU<boolean>;
    get mucImageState() {
        return this.__mucImageState.get();
    }
    set mucImageState(newValue: boolean) {
        this.__mucImageState.set(newValue);
    }
    private __mucImageName: ObservedPropertyObjectPU<Resource>;
    get mucImageName() {
        return this.__mucImageName.get();
    }
    set mucImageName(newValue: Resource) {
        this.__mucImageName.set(newValue);
    }
    private __actImageName: ObservedPropertySimplePU<string>;
    get actImageName() {
        return this.__actImageName.get();
    }
    set actImageName(newValue: string) {
        this.__actImageName.set(newValue);
    }
    private __tipString: ObservedPropertySimplePU<string>;
    get tipString() {
        return this.__tipString.get();
    }
    set tipString(newValue: string) {
        this.__tipString.set(newValue);
    }
    private __currentImage: ObservedPropertySimplePU<string>;
    get currentImage() {
        return this.__currentImage.get();
    }
    set currentImage(newValue: string) {
        this.__currentImage.set(newValue);
    }
    private __translateY: ObservedPropertySimplePU<number>;
    get translateY() {
        return this.__translateY.get();
    }
    set translateY(newValue: number) {
        this.__translateY.set(newValue);
    }
    private __isMoving: ObservedPropertySimplePU<boolean>;
    get isMoving() {
        return this.__isMoving.get();
    }
    set isMoving(newValue: boolean) {
        this.__isMoving.set(newValue);
    }
    private __context: ObservedPropertyObjectPU<Context>;
    get context() {
        return this.__context.get();
    }
    set context(newValue: Context) {
        this.__context.set(newValue);
    }
    private mXComponentController: XComponentController;
    private __surfaceId: ObservedPropertySimplePU<string>;
    get surfaceId() {
        return this.__surfaceId.get();
    }
    set surfaceId(newValue: string) {
        this.__surfaceId.set(newValue);
    }
    private permissions: Array<Permissions>;
    private startCountdown() {
        this.intervalId = setInterval(() => {
            if (this.remainTime > 0) {
                this.remainTime--;
            }
            else {
                this.stopCountdown();
            }
        }, 1000);
    }
    private stopCountdown() {
        if (this.intervalId !== null) {
            clearInterval(this.intervalId);
            this.intervalId = null;
        }
    }
    aboutToDisappear(): void {
        CLRealPersonManager.getInstance().stopLiveDetect();
        this.stopCountdown();
    }
    aboutToAppear(): void {
        // 初始化音频播放器
        CLAVPlayer.instance.createAVPlayer();
        this.startCountdown();
        setTimeout(() => {
            Logger.info(`活体检测-传入context:${this.context},surfaceId:${this.surfaceId}`);
            CLRealPersonManager.getInstance().initWithRecordView(this.context, this.surfaceId);
            Logger.info(`活体检测-启动`);
            CLRealPersonManager.getInstance().startLiveDetectWithActionsHandler((params: CLTypeParamObject, url?: string) => {
                Logger.info(`活体检测-动作检测过程：${JSON.stringify(params)}`);
                this.currentImage = url ?? '';
                this.updateTitleWithDic(params);
            }, (status: CLStatus, params: any) => {
                Logger.info(`活体检测-结果...`);
                this.updateCompletionStatus(status, params);
            });
        }, 200);
    }
    updateTitleWithDic(params: CLTypeParamObject) {
        if (!params) {
            return;
        }
        if (params.type === '1') {
            if (params.result === '1') {
                this.tipString = "请保持姿势不变";
            }
            else if (params.result === '2') {
                this.tipString = "请面向屏幕";
            }
            else if (params.result === '3') {
                this.tipString = "请保持脸在检测框内";
            }
            else if (params.result === '4') {
                this.tipString = "请靠近一点";
            }
            else if (params.result === '5') {
                this.tipString = "当前光线过暗，请调整";
            }
            else if (params.result === '6') {
                this.tipString = "当前光线模糊，请调整";
            }
            else if (params.result === '7') {
                this.tipString = "请露出全脸";
            }
        }
        else if (params.type === '2') {
            if (params.result === '-1') {
                //开始检测
                // 圆形进度条倒计时
            }
            else if (params.result === '0') {
                this.tipString = "请眨眼";
            }
            else if (params.result === '4') {
                this.tipString = "请抬头";
            }
            else if (params.result === '5') {
                this.tipString = "请低头";
            }
            else if (params.result === '6') {
                this.tipString = "请张嘴";
            }
            else if (params.result === '7') {
                this.tipString = "请摇头";
            }
            else {
                CLRealPersonManager.getInstance().stopLiveDetect();
                return;
            }
            this.actImageName = `act_${params.result}`;
            setTimeout(async () => {
                let rawFile = await this.context.resourceManager.getRawFd(`muc_${params.result}.mp3`);
                CLAVPlayer.instance.play(rawFile);
            });
        }
        else if (params.type === '3') {
            if (params.result === '1') {
                this.tipString = "检测中";
                this.isMoving = true;
            }
        }
        else if (params.type === '4') {
            // 上传
            this.tipString = "检测完成";
            CLRealPersonManager.getInstance().resultWithDetectUrl(params.result, false);
        }
    }
    updateCompletionStatus(status: CLStatus, params: any) {
        this.isMoving = false;
        // 结束各种动画
        if (status === CLStatus.CLCheckPass) {
            this.tipString = "活体检测成功";
            Logger.info(`活体检测-结果:成功`);
            promptAction.showToast({
                message: '活体检测成功'
            });
        }
        else if (status === CLStatus.CLOperationTimeout) {
            promptAction.showToast({
                message: '检测已超时'
            });
            Logger.info(`活体检测-结果:超时`);
        }
        else if (status === CLStatus.CLRPNoMoney) {
            Logger.info(`活体检测-结果:余额不足`);
            promptAction.showToast({ message: '余额不足' });
        }
        else if (status === CLStatus.CLNetError) {
            Logger.info(`活体检测-结果:网络错误`);
            promptAction.showToast({ message: '网络错误' });
        }
        else {
            Logger.info(`活体检测-结果:活体检测失败`);
            promptAction.showToast({ message: '活体检测失败' });
        }
        router.back();
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 倒计时
            Row.create();
            // 倒计时
            Row.justifyContent(FlexAlign.SpaceBetween);
            // 倒计时
            Row.width('80%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.mucImageState ? { "id": 16777262, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" } : { "id": 16777261, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('30');
            Image.height('30');
            Image.onClick(() => {
                this.mucImageState = !this.mucImageState;
            });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create();
            Stack.width(60);
            Stack.height(60);
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Progress.create({
                value: (this.remainTime / this.totalTime) * 300,
                total: 300,
                type: ProgressType.Ring
            });
            Progress.color(Color.Green);
            Progress.backgroundColor(Color.Gray);
            Progress.width('100%');
            Progress.height('100%');
        }, Progress);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(`${this.remainTime.toString()}s`);
            Text.fontSize(30);
            Text.width('100%');
            Text.height('100%');
            Text.textAlign(TextAlign.Center);
        }, Text);
        Text.pop();
        Stack.pop();
        // 倒计时
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 提示信息
            Row.create();
            // 提示信息
            Row.width('100%');
            // 提示信息
            Row.justifyContent(FlexAlign.Center);
            // 提示信息
            Row.margin({ top: 30 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.tipString);
            Text.textAlign(TextAlign.Center);
            Text.fontSize(20);
            Text.fontWeight(FontWeight.Bold);
            Text.fontColor('#333333');
        }, Text);
        Text.pop();
        // 提示信息
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 相机框
            Row.create();
            // 相机框
            Row.width('100%');
            // 相机框
            Row.justifyContent(FlexAlign.Center);
            // 相机框
            Row.margin({ top: 30 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create();
            Stack.alignContent(Alignment.Center);
            Stack.backgroundColor(Color.Gray);
            Stack.width('80%');
            Stack.aspectRatio(1);
            Stack.borderRadius('50%');
            Stack.clip(true);
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            XComponent.create({
                type: XComponentType.SURFACE,
                controller: this.mXComponentController,
            }, "com.example.realauth/RealAuthDemo");
            XComponent.width('100%');
            XComponent.height('100%');
            XComponent.onLoad(() => {
                this.surfaceId = this.mXComponentController.getXComponentSurfaceId();
            });
        }, XComponent);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Progress.create({
                value: (this.remainTime / this.totalTime) * 300,
                total: 300,
                type: ProgressType.Ring,
            });
            Progress.color(Color.Green);
            Progress.backgroundColor(Color.Gray);
            Progress.width('100%');
            Progress.height('100%');
        }, Progress);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777268, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.objectFit(ImageFit.Fill);
            Image.width('50%');
            Image.height('50%');
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (this.isMoving) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Image.create({ "id": 16777273, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                        Context.animation({
                            duration: 1000,
                            curve: Curve.Linear,
                            playMode: PlayMode.Alternate,
                            iterations: this.isMoving ? -1 : 0,
                        });
                        Image.translate({ y: this.translateY });
                        Context.animation(null);
                        Image.width('100%');
                        Image.height(30);
                        Image.onAppear(() => {
                            this.translateY = 150;
                        });
                    }, Image);
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Image.create({ "id": 16777273, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                        Context.animation({
                            duration: 1000,
                            curve: Curve.Linear,
                            playMode: PlayMode.Alternate,
                            iterations: 0,
                        });
                        Image.translate({ y: 0 });
                        Context.animation(null);
                        Image.width('100%');
                        Image.height(30);
                        Image.visibility(Visibility.Hidden);
                    }, Image);
                });
            }
        }, If);
        If.pop();
        Stack.pop();
        // 相机框
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.justifyContent(FlexAlign.Center);
            Row.margin({ top: 10 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": -1, "type": -1, params: [`app.media.${this.actImageName}`], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('123');
            Image.height('111');
        }, Image);
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.currentImage);
            Image.objectFit(ImageFit.Fill);
            Image.width('100');
            Image.height('100');
        }, Image);
        Row.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLLivingVideoPage";
    }
}
{
    let routeNameNode = 'CLLivingVideoPage';
    registerNamedRoute(() => new CLLivingVideoPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/detect/CLLivingVideoPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/detect/CLLivingVideoPage", integratedHsp: "false", moduleType: "followWithHap" });
}
