if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCRPage_Params {
    front_image?: string | PixelMap | Resource;
    back_image?: string | PixelMap | Resource;
    message?: string;
}
import router from "@ohos:router";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCRTakePhotoPage&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCREditPage&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCREditPage1&";
import { CLOCRManager } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import type { CLResult, CLOCRSideMessage } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import fs from "@ohos:file.fs";
import { CLCommon } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCommon&";
import { RouterPage } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import { CLToast } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLHud&";
import Logger from "@normalized:N&&&realauthdemo/src/main/ets/common/Logger&";
class CLOCRPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__front_image = this.createStorageLink('cl_front_image', { "id": 16777247, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, "front_image");
        this.__back_image = this.createStorageLink('cl_back_image', { "id": 16777248, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, "back_image");
        this.__message = new ObservedPropertySimplePU('Hello World', this, "message");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCRPage_Params) {
        if (params.message !== undefined) {
            this.message = params.message;
        }
    }
    updateStateVars(params: CLOCRPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__front_image.purgeDependencyOnElmtId(rmElmtId);
        this.__back_image.purgeDependencyOnElmtId(rmElmtId);
        this.__message.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__front_image.aboutToBeDeleted();
        this.__back_image.aboutToBeDeleted();
        this.__message.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __front_image: ObservedPropertyAbstractPU<string | PixelMap | Resource>;
    get front_image() {
        return this.__front_image.get();
    }
    set front_image(newValue: string | PixelMap | Resource) {
        this.__front_image.set(newValue);
    }
    private __back_image: ObservedPropertyAbstractPU<string | PixelMap | Resource>;
    get back_image() {
        return this.__back_image.get();
    }
    set back_image(newValue: string | PixelMap | Resource) {
        this.__back_image.set(newValue);
    }
    private __message: ObservedPropertySimplePU<string>;
    get message() {
        return this.__message.get();
    }
    set message(newValue: string) {
        this.__message.set(newValue);
    }
    readSandFile2ArrayBuffer(sandFilePath: string): ArrayBuffer {
        console.info('sandFilePath:', sandFilePath);
        let stat = fs.statSync(sandFilePath);
        let sandFile = fs.openSync(sandFilePath, fs.OpenMode.READ_ONLY);
        let arrayBuffer = new ArrayBuffer(stat.size);
        fs.readSync(sandFile.fd, arrayBuffer);
        fs.closeSync(sandFile);
        return arrayBuffer;
    }
    aboutToAppear(): void {
        console.log('哈哈哈哈111' + JSON.stringify(AppStorage.get('cl_front_image')));
    }
    onPageShow(): void {
        console.log('哈哈哈哈' + JSON.stringify(this.front_image));
    }
    aboutToDisappear(): void {
        console.log('进入 aboutToDisappear');
    }
    onPageHide(): void {
        console.log('进入 onPageHide');
    }
    onPageDestroy() {
        console.info('[MyPage] 页面已被销毁');
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Navigation.create(new NavPathStack(), { moduleName: "RealAuthDemo", pagePath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRPage", isUserCreateStack: false });
            Navigation.title('上传身份证');
            Navigation.hideBackButton(false);
            Navigation.titleMode(NavigationTitleMode.Mini);
        }, Navigation);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.padding({ top: 20, left: 67, right: 67 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('请上传本人身份证');
            Text.fontSize(18);
            Text.fontColor('#232323');
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.front_image);
            Image.height('190');
            Image.aspectRatio(1.6);
            Image.objectFit(ImageFit.Cover);
            Image.margin({ top: 8 });
            Image.onClick(() => {
                router.pushNamedRoute({
                    name: 'CLOCRTakePhotoPage',
                    params: { cardType: 0, isBack: true }
                });
            });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('身份证头像照');
            Text.fontSize(14);
            Text.fontColor('#E5E5E5');
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.back_image);
            Image.height('190');
            Image.aspectRatio(1.6);
            Image.objectFit(ImageFit.Cover);
            Image.margin({ top: 8 });
            Image.onClick(() => {
                router.pushNamedRoute({
                    name: 'CLOCRTakePhotoPage',
                    params: { cardType: 1, isBack: true }
                });
            });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('身份证国徽照');
            Text.fontSize(14);
            Text.fontColor('#E5E5E5');
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.padding({ left: 20, right: 20 });
            Row.margin({ top: 45 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('提交');
            Button.fontSize(18);
            Button.fontColor('#ffffff');
            Button.backgroundColor('#60b1fe');
            Button.width('100%');
            Button.height('50');
            Button.onClick(async () => {
                if (typeof this.front_image === 'object') {
                    const res = this.front_image as Resource;
                    const defaultRes = { "id": 16777247, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" } as Resource;
                    if (res.id === defaultRes.id) {
                        CLToast.showMessage(this.getUIContext(), "请上传图片");
                        Logger.info('OCR识别-未上传图片');
                        return;
                    }
                }
                if (typeof this.back_image === 'object') {
                    const res = this.back_image as Resource;
                    const defaultRes = { "id": 16777247, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" } as Resource;
                    if (res.id === defaultRes.id) {
                        CLToast.showMessage(this.getUIContext(), "请上传图片");
                        Logger.info('OCR识别-未上传图片');
                        return;
                    }
                }
                // 提交图片检测
                let front_pix = this.front_image as PixelMap;
                let back_pix = this.back_image as PixelMap;
                // if (typeof this.front_image === 'string') {
                //   front_pix = await CLCommon.uri2PixelMap(this.front_image as string)
                // }
                if (typeof this.back_image === 'string' && typeof this.front_image === 'string') {
                    back_pix = await CLCommon.uri2PixelMap(this.back_image as string);
                    front_pix = await CLCommon.uri2PixelMap(this.front_image as string);
                }
                CLToast.showLoading(this.getUIContext());
                AppStorage.setOrCreate('rxImagePixMap', front_pix);
                AppStorage.setOrCreate('ghImagePixMap', back_pix);
                let result = await CLOCRManager.realPersonOCR(front_pix, back_pix) as CLResult<CLOCRSideMessage>;
                if (result.code !== '000000' && result.message) {
                    CLToast.hideHud();
                    CLToast.showMessage(this.getUIContext(), result.message);
                    return;
                }
                if (!result.data || !result.data.front.id_card_no || !result.data.front.name) {
                    CLToast.hideHud();
                    CLToast.showMessage(this.getUIContext(), "OCR识别未识别出结果");
                    Logger.info('OCR识别未识别出结果');
                    return;
                }
                CLToast.hideHud();
                let rxResult: any = { code: result.code, message: result.message, data: result.data.front };
                let ghResult: any = { code: result.code, message: result.message, data: result.data.back };
                router.pushNamedRoute({
                    name: RouterPage.OCRSubmitPage,
                    params: {
                        rxResult: rxResult,
                        ghResult: ghResult
                    }
                });
            });
        }, Button);
        Button.pop();
        Row.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('正反面单独识别');
            Text.fontSize(16);
            Text.fontColor('#60b1fe');
            Text.textAlign(TextAlign.Center);
            Text.width('100%');
            Text.padding({ left: '20%', right: '20%' });
            Text.margin({ top: 10 });
            Text.onClick((event: ClickEvent) => {
                router.pushNamedRoute({
                    name: 'CLOCRTakePhotoPage',
                    params: { cardType: 0, isBack: false }
                });
            });
        }, Text);
        Text.pop();
        Row.pop();
        Navigation.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCRPage";
    }
}
{
    let routeNameNode = 'CLOCRPage';
    registerNamedRoute(() => new CLOCRPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCRPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRPage", integratedHsp: "false", moduleType: "followWithHap" });
}
