if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCRTakePhotoPage_Params {
    imageMask?: Resource | string;
    titlePlacehold?: string;
    rxResult?: ESObject;
    ghResult?: ESObject;
    cardType?: number;
    isBack?: boolean;
    context?: Context;
    mXComponentController?: XComponentController;
    imageList?: Resource[];
    imageTitle?: string[];
    surfaceId?: string;
    permissions?: Array<Permissions>;
}
import CLCameraService from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCameraService&";
import abilityAccessCtrl from "@ohos:abilityAccessCtrl";
import type { Permissions as Permissions } from "@ohos:abilityAccessCtrl";
import type photoAccessHelper from "@ohos:file.photoAccessHelper";
import router from "@ohos:router";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCRUploadCardPage&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCREditPage1&";
import type { OCRTakePhotoParam } from '../CLParams';
export class CLOCRTakePhotoPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__imageMask = new ObservedPropertyObjectPU('', this, "imageMask");
        this.__titlePlacehold = new ObservedPropertySimplePU('', this, "titlePlacehold");
        this.rxResult = undefined;
        this.ghResult = undefined;
        this.__cardType = new ObservedPropertySimplePU(0, this, "cardType");
        this.__isBack = new ObservedPropertySimplePU(true, this, "isBack");
        this.__context = new ObservedPropertyObjectPU(this.getUIContext().getHostContext()!, this, "context");
        this.mXComponentController = new XComponentController;
        this.imageList = [
            { "id": 16777255, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" },
            { "id": 16777256, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" },
            { "id": 16777257, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" },
            { "id": 16777258, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" },
        ];
        this.imageTitle = [
            '标准拍摄', '边框缺失', '照片模糊', '闪光强烈'
        ];
        this.__surfaceId = new ObservedPropertySimplePU('', this, "surfaceId");
        this.permissions = [
            'ohos.permission.CAMERA',
            'ohos.permission.MICROPHONE',
            'ohos.permission.MEDIA_LOCATION',
            'ohos.permission.READ_IMAGEVIDEO',
            'ohos.permission.WRITE_IMAGEVIDEO',
        ];
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCRTakePhotoPage_Params) {
        if (params.imageMask !== undefined) {
            this.imageMask = params.imageMask;
        }
        if (params.titlePlacehold !== undefined) {
            this.titlePlacehold = params.titlePlacehold;
        }
        if (params.rxResult !== undefined) {
            this.rxResult = params.rxResult;
        }
        if (params.ghResult !== undefined) {
            this.ghResult = params.ghResult;
        }
        if (params.cardType !== undefined) {
            this.cardType = params.cardType;
        }
        if (params.isBack !== undefined) {
            this.isBack = params.isBack;
        }
        if (params.context !== undefined) {
            this.context = params.context;
        }
        if (params.mXComponentController !== undefined) {
            this.mXComponentController = params.mXComponentController;
        }
        if (params.imageList !== undefined) {
            this.imageList = params.imageList;
        }
        if (params.imageTitle !== undefined) {
            this.imageTitle = params.imageTitle;
        }
        if (params.surfaceId !== undefined) {
            this.surfaceId = params.surfaceId;
        }
        if (params.permissions !== undefined) {
            this.permissions = params.permissions;
        }
    }
    updateStateVars(params: CLOCRTakePhotoPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__imageMask.purgeDependencyOnElmtId(rmElmtId);
        this.__titlePlacehold.purgeDependencyOnElmtId(rmElmtId);
        this.__cardType.purgeDependencyOnElmtId(rmElmtId);
        this.__isBack.purgeDependencyOnElmtId(rmElmtId);
        this.__context.purgeDependencyOnElmtId(rmElmtId);
        this.__surfaceId.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__imageMask.aboutToBeDeleted();
        this.__titlePlacehold.aboutToBeDeleted();
        this.__cardType.aboutToBeDeleted();
        this.__isBack.aboutToBeDeleted();
        this.__context.aboutToBeDeleted();
        this.__surfaceId.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    // @StorageLink front_image:string = ''
    // @StorageLink back_image:string = ''
    private __imageMask: ObservedPropertyObjectPU<Resource | string>;
    get imageMask() {
        return this.__imageMask.get();
    }
    set imageMask(newValue: Resource | string) {
        this.__imageMask.set(newValue);
    }
    private __titlePlacehold: ObservedPropertySimplePU<string>;
    get titlePlacehold() {
        return this.__titlePlacehold.get();
    }
    set titlePlacehold(newValue: string) {
        this.__titlePlacehold.set(newValue);
    }
    private rxResult: any;
    private ghResult: any;
    private __cardType: ObservedPropertySimplePU<number>;
    get cardType() {
        return this.__cardType.get();
    }
    set cardType(newValue: number) {
        this.__cardType.set(newValue);
    }
    private __isBack: ObservedPropertySimplePU<boolean>;
    get isBack() {
        return this.__isBack.get();
    }
    set isBack(newValue: boolean) {
        this.__isBack.set(newValue);
    }
    private __context: ObservedPropertyObjectPU<Context>;
    get context() {
        return this.__context.get();
    }
    set context(newValue: Context) {
        this.__context.set(newValue);
    }
    private mXComponentController: XComponentController;
    private imageList: Resource[];
    private imageTitle: string[];
    private __surfaceId: ObservedPropertySimplePU<string>;
    get surfaceId() {
        return this.__surfaceId.get();
    }
    set surfaceId(newValue: string) {
        this.__surfaceId.set(newValue);
    }
    private permissions: Array<Permissions>;
    getImageMask(cardType: number) {
        if (cardType === 1) {
            return { "id": 16777271, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" };
        }
        return { "id": 16777251, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" };
    }
    getTipTextString(cardType: number) {
        if (cardType === 1) {
            return '将身份证国徽页置于此区域，避免晃动和反光';
        }
        return '将身份证人像页置于此区域，避免晃动和反光';
    }
    imageRXBuilder(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width(300);
            Column.aspectRatio(1.6);
            Column.justifyContent(FlexAlign.Start);
            Column.alignItems(HorizontalAlign.End);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777271, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width(100);
            Image.aspectRatio(0.8);
            Image.margin({ top: '12%', right: '10%' });
        }, Image);
        Column.pop();
    }
    imageGHBuilder(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width(300);
            Column.aspectRatio(1.6);
            Column.justifyContent(FlexAlign.Start);
            Column.alignItems(HorizontalAlign.Start);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777251, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width(60);
            Image.aspectRatio(1);
            Image.margin({ top: '7%', left: '10%' });
        }, Image);
        Column.pop();
    }
    aboutToDisappear(): void {
        CLCameraService.releaseCamera();
    }
    aboutToAppear(): void {
        const params = this.getUIContext().getRouter().getParams() as OCRTakePhotoParam;
        this.cardType = params.cardType;
        this.isBack = params.isBack;
        this.rxResult = params.rxResult;
        this.ghResult = params.ghResult;
        this.imageMask = this.getImageMask(this.cardType);
        this.titlePlacehold = this.getTipTextString(this.cardType);
        console.log('🔥输出当前的CLOCRTakePhotoPage：' + JSON.stringify(params));
        abilityAccessCtrl.createAtManager().requestPermissionsFromUser(this.context, this.permissions)
            .then(() => {
            setTimeout(async () => {
                CLCameraService.initCamera(this.context, this.surfaceId);
            }, 200);
        });
        // 获取拍照照片
        CLCameraService.setSavePictureCallback((phototAsset: photoAccessHelper.PhotoAsset) => {
            let imageData = CLCameraService.getImageUint8Array(phototAsset.uri);
            if (this.isBack) {
                if (this.cardType === 1) {
                    AppStorage.setOrCreate('cl_back_image', phototAsset.uri);
                }
                else {
                    AppStorage.setOrCreate('cl_front_image', phototAsset.uri);
                }
                router.back();
            }
            else {
                // 编辑图片
                router.pushNamedRoute({
                    name: 'CLOCREditPage1',
                    params: {
                        imagePath: phototAsset.uri,
                        cardType: this.cardType,
                        rxResult: this.rxResult,
                    }
                });
            }
            console.log('拍照完成' + phototAsset);
        });
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.backgroundColor('#ffffff');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 相机
            // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
            Stack.create({ alignContent: Alignment.End });
            // 相机
            // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
            Stack.width('100%');
            // 相机
            // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
            Stack.height('300');
            // 相机
            // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
            Stack.padding({ left: 46, right: 46 });
            // 相机
            // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
            Stack.backgroundColor('#FAFAFA');
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            XComponent.create({
                type: XComponentType.SURFACE,
                controller: this.mXComponentController,
            }, "com.example.realauth/RealAuthDemo");
            XComponent.width(300);
            XComponent.aspectRatio(1.6);
            XComponent.renderFit(RenderFit.RESIZE_FILL);
            XComponent.onLoad(() => {
                this.mXComponentController.setXComponentSurfaceRect({ surfaceWidth: 1080, surfaceHeight: 1080 });
                this.surfaceId = this.mXComponentController.getXComponentSurfaceId();
            });
        }, XComponent);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (this.cardType === 1) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.imageGHBuilder.bind(this)();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.imageRXBuilder.bind(this)();
                });
            }
        }, If);
        If.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.titlePlacehold);
            Text.fontSize(14);
            Text.fontColor('#606581');
            Text.width('100%');
            Text.textAlign(TextAlign.Center);
            Text.position({ left: 0, right: 0, bottom: 10 });
        }, Text);
        Text.pop();
        // 相机
        // https://developer.huawei.com/consumer/cn/doc/best-practices/bpta-third-party-cameraCameraMgr.ets
        Stack.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 操作及说明
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 相册，拍摄，手电筒按钮
            Row.create();
            // 相册，拍摄，手电筒按钮
            Row.width('100%');
            // 相册，拍摄，手电筒按钮
            Row.padding({ left: 47, right: 47, top: 37 });
            // 相册，拍摄，手电筒按钮
            Row.alignItems(VerticalAlign.Center);
            // 相册，拍摄，手电筒按钮
            Row.justifyContent(FlexAlign.SpaceBetween);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777267, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('44');
            Image.aspectRatio(1);
            Image.onClick(() => {
                CLCameraService.openPhotoAlbum((imageURL: string, eror?: Error) => {
                    console.log('选择照片' + imageURL);
                    router.pushNamedRoute({
                        name: 'CLOCREditPage1',
                        params: {
                            imagePath: imageURL,
                            cardType: this.cardType,
                            isBack: this.isBack,
                            rxResult: this.rxResult,
                        }
                    });
                    // if (this.cardType ===0 && this.isBack) {
                    //   AppStorage.setOrCreate('cl_front_image',imageURL)
                    //   router.back()
                    // }else if(this.cardType ===1 && this.isBack){
                    //   AppStorage.setOrCreate('cl_back_image',imageURL)
                    //   router.back()
                    // }else{
                    //   router.pushNamedRoute({
                    //     name:'CLOCREditPage1',
                    //     params:{imagePath:imageURL,cardType:this.cardType,isBack:this.isBack}
                    //   })
                    // }
                });
            });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('相册');
            Text.fontSize(12);
            Text.fontColor('#747991');
            Text.margin({ top: 5 });
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777276, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('73');
            Image.aspectRatio(1);
            Image.onClick(() => {
                CLCameraService.takePicture();
            });
        }, Image);
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777260, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('44');
            Image.aspectRatio(1);
            Image.onClick(() => {
                CLCameraService.setFlashMode();
            });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('手电筒');
            Text.fontSize(12);
            Text.fontColor('#747991');
            Text.margin({ top: 5 });
        }, Text);
        Text.pop();
        Column.pop();
        // 相册，拍摄，手电筒按钮
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('————————— 拍摄标准 —————————');
            Text.fontColor('#656477');
            Text.fontSize(13);
            Text.margin({ top: 50 });
            Text.width('100%');
            Text.textAlign(TextAlign.Center);
            Text.padding({ left: 30, right: 30 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.justifyContent(FlexAlign.SpaceBetween);
            Row.width('100%');
            Row.margin({ top: 14 });
            Row.padding({ left: 30, right: 30 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            ForEach.create();
            const forEachItemGenFunction = (_item, index: number) => {
                const item = _item;
                this.observeComponentCreation2((elmtId, isInitialRender) => {
                    Column.create();
                }, Column);
                this.observeComponentCreation2((elmtId, isInitialRender) => {
                    Image.create(this.imageList[index]);
                    Image.width('73');
                    Image.height('48');
                }, Image);
                this.observeComponentCreation2((elmtId, isInitialRender) => {
                    Row.create();
                    Row.margin({ top: 5 });
                }, Row);
                this.observeComponentCreation2((elmtId, isInitialRender) => {
                    If.create();
                    if (index == 0) {
                        this.ifElseBranchUpdateFunction(0, () => {
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Image.create({ "id": 16777254, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                                Image.width('10');
                                Image.height('7');
                            }, Image);
                        });
                    }
                    else {
                        this.ifElseBranchUpdateFunction(1, () => {
                            this.observeComponentCreation2((elmtId, isInitialRender) => {
                                Image.create({ "id": 16777249, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                                Image.width('10');
                                Image.height('7');
                            }, Image);
                        });
                    }
                }, If);
                If.pop();
                this.observeComponentCreation2((elmtId, isInitialRender) => {
                    Text.create(this.imageTitle[index]);
                    Text.fontColor('#656477');
                    Text.fontSize(12);
                    Text.margin({ left: 3 });
                }, Text);
                Text.pop();
                Row.pop();
                Column.pop();
            };
            this.forEachUpdateFunction(elmtId, this.imageTitle, forEachItemGenFunction, undefined, true, false);
        }, ForEach);
        ForEach.pop();
        Row.pop();
        // 操作及说明
        Column.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCRTakePhotoPage";
    }
}
{
    let routeNameNode = 'CLOCRTakePhotoPage';
    registerNamedRoute(() => new CLOCRTakePhotoPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCRTakePhotoPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRTakePhotoPage", integratedHsp: "false", moduleType: "followWithHap" });
}
