if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCRUploadCardPage_Params {
    alone_front_image?: string;
    cardType?: number;
    nextBtnTitle?: string;
    lineColor?: string;
    ghImage?: Resource;
    imagePath?: string | image.PixelMap | undefined;
    rxResult?: ESObject;
    ghResult?: ESObject;
}
import image from "@ohos:multimedia.image";
import { RouterPage } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import type { UploadCardParam } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import router from "@ohos:router";
import { CLOCRManager } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import type { CLOCRCardMessage, CLResult } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import { CLToast } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLHud&";
import Logger from "@normalized:N&&&realauthdemo/src/main/ets/common/Logger&";
class CLOCRUploadCardPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__alone_front_image = this.createStorageProp('cl_alone_front_image', '', "alone_front_image");
        this.__cardType = new ObservedPropertySimplePU(0, this, "cardType");
        this.__nextBtnTitle = new ObservedPropertySimplePU('下一步', this, "nextBtnTitle");
        this.__lineColor = new ObservedPropertySimplePU('#C4C9D5', this, "lineColor");
        this.__ghImage = new ObservedPropertyObjectPU({ "id": 16777253, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, this, "ghImage");
        this.__imagePath = new ObservedPropertyObjectPU('', this, "imagePath");
        this.rxResult = undefined;
        this.ghResult = undefined;
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCRUploadCardPage_Params) {
        if (params.cardType !== undefined) {
            this.cardType = params.cardType;
        }
        if (params.nextBtnTitle !== undefined) {
            this.nextBtnTitle = params.nextBtnTitle;
        }
        if (params.lineColor !== undefined) {
            this.lineColor = params.lineColor;
        }
        if (params.ghImage !== undefined) {
            this.ghImage = params.ghImage;
        }
        if (params.imagePath !== undefined) {
            this.imagePath = params.imagePath;
        }
        if (params.rxResult !== undefined) {
            this.rxResult = params.rxResult;
        }
        if (params.ghResult !== undefined) {
            this.ghResult = params.ghResult;
        }
    }
    updateStateVars(params: CLOCRUploadCardPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__alone_front_image.purgeDependencyOnElmtId(rmElmtId);
        this.__cardType.purgeDependencyOnElmtId(rmElmtId);
        this.__nextBtnTitle.purgeDependencyOnElmtId(rmElmtId);
        this.__lineColor.purgeDependencyOnElmtId(rmElmtId);
        this.__ghImage.purgeDependencyOnElmtId(rmElmtId);
        this.__imagePath.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__alone_front_image.aboutToBeDeleted();
        this.__cardType.aboutToBeDeleted();
        this.__nextBtnTitle.aboutToBeDeleted();
        this.__lineColor.aboutToBeDeleted();
        this.__ghImage.aboutToBeDeleted();
        this.__imagePath.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __alone_front_image: ObservedPropertyAbstractPU<string>;
    get alone_front_image() {
        return this.__alone_front_image.get();
    }
    set alone_front_image(newValue: string) {
        this.__alone_front_image.set(newValue);
    }
    private __cardType: ObservedPropertySimplePU<number>;
    get cardType() {
        return this.__cardType.get();
    }
    set cardType(newValue: number) {
        this.__cardType.set(newValue);
    }
    private __nextBtnTitle: ObservedPropertySimplePU<string>;
    get nextBtnTitle() {
        return this.__nextBtnTitle.get();
    }
    set nextBtnTitle(newValue: string) {
        this.__nextBtnTitle.set(newValue);
    }
    private __lineColor: ObservedPropertySimplePU<string>;
    get lineColor() {
        return this.__lineColor.get();
    }
    set lineColor(newValue: string) {
        this.__lineColor.set(newValue);
    }
    private __ghImage: ObservedPropertyObjectPU<Resource>;
    get ghImage() {
        return this.__ghImage.get();
    }
    set ghImage(newValue: Resource) {
        this.__ghImage.set(newValue);
    }
    private __imagePath: ObservedPropertyObjectPU<string | image.PixelMap | undefined>;
    get imagePath() {
        return this.__imagePath.get();
    }
    set imagePath(newValue: string | image.PixelMap | undefined) {
        this.__imagePath.set(newValue);
    }
    private rxResult: any;
    private ghResult: any;
    navigationTitle(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.alignItems(HorizontalAlign.Center);
            Column.width('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('上传证件');
            Text.fontColor('#182431');
            Text.fontSize(30);
            Text.lineHeight(41);
            Text.fontWeight(700);
        }, Text);
        Text.pop();
        Row.pop();
        Column.pop();
    }
    tipImageBtn(res: Resource, text: string, color: string, parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(res);
            Image.width(60);
            Image.height(35);
            Image.objectFit(ImageFit.Contain);
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(text);
            Text.width(90);
            Text.fontSize(12);
            Text.fontColor(color);
            Text.textAlign(TextAlign.Center);
            Text.margin({ top: 8 });
        }, Text);
        Text.pop();
        Column.pop();
    }
    async loadTempImageAndShow(path: string): Promise<PixelMap | undefined> {
        try {
            const source = await image.createImageSource(path);
            const pixelMap = await source.createPixelMap({});
            return pixelMap;
        }
        catch (err) {
            console.error("临时图片加载失败", err);
            return undefined;
        }
    }
    async aboutToAppear() {
        // 根据cardtype判断上传身份证正反面 0：人像； 1：国徽
        let params = this.getUIContext().getRouter().getParams() as UploadCardParam;
        this.cardType = params.cardType;
        this.imagePath = await this.loadTempImageAndShow(params.imagePath);
        this.rxResult = params.rxResult;
        console.log('🔥输出当前的CLOCRUploadCardPage' + JSON.stringify(params));
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Navigation.create(new NavPathStack(), { moduleName: "RealAuthDemo", pagePath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRUploadCardPage", isUserCreateStack: false });
            Navigation.title('上传证件');
            Navigation.hideBackButton(false);
            Navigation.titleMode(NavigationTitleMode.Mini);
        }, Navigation);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.alignItems(HorizontalAlign.Center);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.justifyContent(FlexAlign.SpaceBetween);
            Row.width('70%');
            Row.margin({ top: 60 });
        }, Row);
        this.tipImageBtn.bind(this)({ "id": 16777272, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '上传人像页', '#3F75FC');
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.backgroundColor(this.lineColor);
            Blank.width('30%');
            Blank.height(1);
            Blank.margin({ bottom: 10 });
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (this.cardType === 1) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.tipImageBtn.bind(this)({ "id": 16777252, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '上传国徽页', '#3F75FC');
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.tipImageBtn.bind(this)({ "id": 16777253, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '上传国徽页', '#C4C9D5');
                });
            }
        }, If);
        If.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('80%');
            Column.backgroundColor('#FFFFFF');
            Column.borderRadius(15);
            Column.margin({ top: 10 });
            Column.shadow({ color: '#F3F3F2', radius: 15, offsetX: 4, offsetY: 4 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.imagePath);
            Image.backgroundColor('#B8CCE3');
            Image.objectFit(ImageFit.Contain);
            Image.width('100%');
            Image.aspectRatio(241 / 163);
            Image.borderRadius(2);
            Image.margin({ top: 25, left: 13, right: 13, bottom: 25 });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('重新拍摄');
            Text.textAlign(TextAlign.Center);
            Text.backgroundColor('#F0F4FE');
            Text.fontColor('#538DF7');
            Text.height(50);
            Text.width('100%');
            Text.onClick(() => {
                router.back(Number(router.getLength()) - 2);
            });
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('80%');
            Row.margin({ top: 80 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.nextBtnTitle);
            Text.fontSize(17);
            Text.fontWeight(FontWeight.Bold);
            Text.fontColor('#FFFFFF');
            Text.height(44);
            Text.width('100%');
            Text.backgroundColor('#538DF7');
            Text.textAlign(TextAlign.Center);
            Text.onClick(async () => {
                if (this.cardType === 0) {
                    let rxImagePixMap = this.imagePath as PixelMap;
                    AppStorage.setOrCreate('rxImagePixMap', rxImagePixMap);
                    CLToast.showLoading(this.getUIContext());
                    let result = await CLOCRManager.realPersonOCROfSignal(rxImagePixMap, true) as CLResult<CLOCRCardMessage>;
                    if (result.code !== '000000') {
                        CLToast.hideHud();
                        CLToast.showMessage(this.getUIContext(), result.message);
                        return;
                    }
                    if (!result.data || !result.data.id_card_no || !result.data.name) {
                        CLToast.hideHud();
                        CLToast.showMessage(this.getUIContext(), "OCR识别未识别出结果");
                        Logger.info('OCR识别未识别出结果');
                        return;
                    }
                    this.rxResult = result;
                    CLToast.hideHud();
                    router.pushNamedRoute({
                        name: RouterPage.OCRUpTakePhotoPage,
                        params: {
                            cardType: 1,
                            rxImagePixMap: rxImagePixMap,
                            rxResult: result
                        }
                    });
                }
                else {
                    let ghImagePixMap = this.imagePath as PixelMap;
                    AppStorage.setOrCreate('ghImagePixMap', ghImagePixMap);
                    CLToast.showLoading(this.getUIContext());
                    let result = await CLOCRManager.realPersonOCROfSignal(ghImagePixMap, false) as CLResult<CLOCRCardMessage>;
                    if (result.code !== '000000' && result.message) {
                        CLToast.hideHud();
                        CLToast.showMessage(this.getUIContext(), result.message);
                        return;
                    }
                    if (!result.data || !result.data.expire_date) {
                        CLToast.hideHud();
                        CLToast.showMessage(this.getUIContext(), "OCR识别未识别出结果");
                        Logger.info('OCR识别未识别出结果');
                        return;
                    }
                    CLToast.hideHud();
                    this.ghResult = result;
                    router.pushNamedRoute({
                        name: RouterPage.OCRSubmitPage,
                        params: {
                            cardType: 1,
                            rxResult: this.rxResult,
                            ghResult: result
                        }
                    });
                }
            });
        }, Text);
        Text.pop();
        Row.pop();
        Column.pop();
        Navigation.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCRUploadCardPage";
    }
}
{
    let routeNameNode = 'CLOCRUploadCardPage';
    registerNamedRoute(() => new CLOCRUploadCardPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCRUploadCardPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRUploadCardPage", integratedHsp: "false", moduleType: "followWithHap" });
}
