import type HashMap from "@ohos:util.HashMap";
import type { BusinessError as BusinessError } from "@ohos:base";
export class CLCoreHttpResopnse {
    code: string = '';
    message: string = '';
    data?: HashMap<string, string>;
    error?: BusinessError;
    isSuccess?: boolean;
    constructor(code: string, message: string, data?: HashMap<string, string>, error?: BusinessError, isSuccess?: boolean) {
        this.code = code;
        this.message = this.message;
        this.data = data;
        this.error = this.error;
        this.isSuccess = this.isSuccess;
    }
}
/**
 * @interface CLResult 返回结果
 * @param code 返回码
 * @param message 返回描述信息
 * @param data 返回数据
 **/
export interface CLResult<T> {
    code: string;
    message: string;
    data: T;
}
/**
 *
 * @instance OCR 认证结果
 * @param orderNo 订单号
 * @param handleTime 处理时间
 * @param province 省
 * @param city 市
 * @param country 镇
 * @param birthday 生日
 * @param age 年龄
 * @param gender 代
 * @param remark
 * @param result
 **/
export interface CLOCRAuthOrderMessage {
    orderNo: string;
    handleTime: string;
    province: string;
    city: string;
    country: string;
    birthday: string;
    age: string;
    gender: string;
    remark: string;
    result: string;
}
/**
 * @instance OCR 识别结果
 * @param back 国徽面信息  CLOCRCardMessage
 * @param front 人像面信息  CLOCRCardMessage
 * */
export interface CLOCRSideMessage {
    back: CLOCRCardMessage;
    front: CLOCRCardMessage;
}
/**
 * @instanceOCR 识别结果
 * @param spcode:string,
 * @param address:string,
 * @param id_card_no:string,
 * @param brith_day:string,
 * @param name:string,
 * @param sex:string,
 * @param nation:string,
 * @param issuing_authority:string
 * @param issuing_date:string
 * @param expire_date:string
 * @param msg:string,
 * @param charge_status:number,
 * @param success:boolean
 **/
export interface CLOCRCardMessage {
    spcode: string;
    address: string;
    id_card_no: string;
    brith_day: string;
    name: string;
    sex: string;
    nation: string;
    issuing_authority: string;
    issuing_date: string;
    expire_date: string;
    msg: string;
    charge_status: number;
    success: boolean;
}
