import hilog from "@ohos:hilog";
import { CLConfigureUtil } from "@normalized:N&&&@wanshu/realauthsdk/src/main/ets/CLConfigureUtil&1.0.0";
import emitter from "@ohos:events.emitter";
export default class CLLog {
    private static _code: number = 0x1111;
    private static _tag: string = "实人认证";
    private static _eventId: string = '0x11110001'; // 日志广播事件ID
    private static _emit(level: string, msg: string) {
        let payload: any = {
            level,
            message: msg,
            timestamp: new Date().toISOString(),
        };
        let event: emitter.InnerEvent = {
            eventId: 34,
            priority: emitter.EventPriority.LOW
        };
        let eventData: emitter.EventData = {
            data: payload
        };
        // 发送eventId为1的事件，事件内容为eventData。
        emitter.emit(event, eventData);
    }
    static logg(msg: string) {
        if (CLConfigureUtil.getPrint()) {
            hilog.debug(CLLog._code, CLLog._tag, '%{public}s', msg);
        }
    }
    static log(msg: string) {
        CLLog._emit('LOG', msg);
        CLLog.debug(msg);
    }
    static debug(msg: string) {
        CLLog._emit('DEBUD', msg);
        if (CLConfigureUtil.getPrint()) {
            hilog.debug(CLLog._code, CLLog._tag, '%{public}s', msg);
        }
    }
    static info(msg: string) {
        CLLog._emit('INFO', msg);
        if (CLConfigureUtil.getPrint()) {
            hilog.info(CLLog._code, CLLog._tag, '%{public}s', msg);
        }
    }
    static warn(msg: string) {
        CLLog._emit('WARN', msg);
        if (CLConfigureUtil.getPrint()) {
            hilog.warn(CLLog._code, CLLog._tag, '%{public}s', msg);
        }
    }
    static error(msg: string) {
        CLLog._emit('ERROR', msg);
        if (CLConfigureUtil.getPrint()) {
            hilog.error(CLLog._code, CLLog._tag, '%{public}s', msg);
        }
    }
}
