if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLLogPage_Params {
    show?: boolean;
    logs?: LogItem[];
    offsetX?: number;
    offsetY?: number;
    lastX?: number;
    lastY?: number;
}
import { CLLogReceiver, CLLogCache } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCoreLog&";
import type { LogItem } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCoreLog&";
export class CLLogPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__show = new ObservedPropertySimplePU(true, this, "show");
        this.__logs = new ObservedPropertyObjectPU([], this, "logs");
        this.__offsetX = new ObservedPropertySimplePU(50, this, "offsetX");
        this.__offsetY = new ObservedPropertySimplePU(100, this, "offsetY");
        this.__lastX = new ObservedPropertySimplePU(0, this, "lastX");
        this.__lastY = new ObservedPropertySimplePU(0, this, "lastY");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLLogPage_Params) {
        if (params.show !== undefined) {
            this.show = params.show;
        }
        if (params.logs !== undefined) {
            this.logs = params.logs;
        }
        if (params.offsetX !== undefined) {
            this.offsetX = params.offsetX;
        }
        if (params.offsetY !== undefined) {
            this.offsetY = params.offsetY;
        }
        if (params.lastX !== undefined) {
            this.lastX = params.lastX;
        }
        if (params.lastY !== undefined) {
            this.lastY = params.lastY;
        }
    }
    updateStateVars(params: CLLogPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__show.purgeDependencyOnElmtId(rmElmtId);
        this.__logs.purgeDependencyOnElmtId(rmElmtId);
        this.__offsetX.purgeDependencyOnElmtId(rmElmtId);
        this.__offsetY.purgeDependencyOnElmtId(rmElmtId);
        this.__lastX.purgeDependencyOnElmtId(rmElmtId);
        this.__lastY.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__show.aboutToBeDeleted();
        this.__logs.aboutToBeDeleted();
        this.__offsetX.aboutToBeDeleted();
        this.__offsetY.aboutToBeDeleted();
        this.__lastX.aboutToBeDeleted();
        this.__lastY.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __show: ObservedPropertySimplePU<boolean>;
    get show() {
        return this.__show.get();
    }
    set show(newValue: boolean) {
        this.__show.set(newValue);
    }
    private __logs: ObservedPropertyObjectPU<LogItem[]>;
    get logs() {
        return this.__logs.get();
    }
    set logs(newValue: LogItem[]) {
        this.__logs.set(newValue);
    }
    private __offsetX: ObservedPropertySimplePU<number>;
    get offsetX() {
        return this.__offsetX.get();
    }
    set offsetX(newValue: number) {
        this.__offsetX.set(newValue);
    }
    private __offsetY: ObservedPropertySimplePU<number>;
    get offsetY() {
        return this.__offsetY.get();
    }
    set offsetY(newValue: number) {
        this.__offsetY.set(newValue);
    }
    private __lastX: ObservedPropertySimplePU<number>;
    get lastX() {
        return this.__lastX.get();
    }
    set lastX(newValue: number) {
        this.__lastX.set(newValue);
    }
    private __lastY: ObservedPropertySimplePU<number>;
    get lastY() {
        return this.__lastY.get();
    }
    set lastY(newValue: number) {
        this.__lastY.set(newValue);
    }
    aboutToAppear(): void {
        if (this.logs.length <= 0) {
            this.logs = CLLogCache.getLogs();
        }
        CLLogReceiver.startListening((log) => {
            console.log('🍊🍊🍊🍊🍊🍊🍊' + JSON.stringify(log));
            this.addLog(log);
        });
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 最外层 Column 包裹页面内容和悬浮窗口
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.justifyContent(FlexAlign.End);
            Row.margin({ top: 44, bottom: 0 });
            Row.height('40');
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
        }, Blank);
        Blank.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 日志窗口内容
            Stack.create();
            // 日志窗口内容
            Stack.width('100%');
            // 日志窗口内容
            Stack.height(400);
            // 日志窗口内容
            Stack.borderRadius(10);
            // 日志窗口内容
            Stack.padding(10);
            // 日志窗口内容
            Stack.visibility(this.show ? Visibility.Visible : Visibility.Hidden);
            // 日志窗口内容
            Stack.backgroundColor('#80000000');
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            List.create({ space: 5 });
            List.height(340);
        }, List);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            ForEach.create();
            const forEachItemGenFunction = _item => {
                const log = _item;
                {
                    const itemCreation = (elmtId, isInitialRender) => {
                        ViewStackProcessor.StartGetAccessRecordingFor(elmtId);
                        itemCreation2(elmtId, isInitialRender);
                        if (!isInitialRender) {
                            ListItem.pop();
                        }
                        ViewStackProcessor.StopGetAccessRecording();
                    };
                    const itemCreation2 = (elmtId, isInitialRender) => {
                        ListItem.create(deepRenderFunction, true);
                    };
                    const deepRenderFunction = (elmtId, isInitialRender) => {
                        itemCreation(elmtId, isInitialRender);
                        this.observeComponentCreation2((elmtId, isInitialRender) => {
                            Text.create(`[${log.timestamp}]：${log.message}`);
                            Text.fontSize(14);
                            Text.fontColor(log.level === 'ERROR' ? '#ff0000' : '#ffffff');
                            Text.width('100%');
                        }, Text);
                        Text.pop();
                        ListItem.pop();
                    };
                    this.observeComponentCreation2(itemCreation2, ListItem);
                    ListItem.pop();
                }
            };
            this.forEachUpdateFunction(elmtId, this.logs, forEachItemGenFunction, (log: LogItem) => log.id, false, false);
        }, ForEach);
        ForEach.pop();
        List.pop();
        Column.pop();
        // 日志窗口内容
        Stack.pop();
        // 最外层 Column 包裹页面内容和悬浮窗口
        Column.pop();
    }
    // 添加日志
    addLog(msg: LogItem) {
        msg.id = `${msg.timestamp}_${Math.random()}`;
        this.logs.push(msg);
        if (this.logs.length > 200)
            this.logs.shift(); // 保持最多200条日志
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLLogPage";
    }
}
{
    let routeNameNode = 'CLLogPage';
    registerNamedRoute(() => new CLLogPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/CLLogPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/CLLogPage", integratedHsp: "false", moduleType: "followWithHap" });
}
