if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface Index_Params {
    message?: string;
    version?: string;
}
import "@normalized:N&&&realauthdemo/src/main/ets/pages/detect/CLLivingPage&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCRPage&";
import { CLRequest } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLRequest&";
import type { CLResponse } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLRequest&";
import promptAction from "@ohos:promptAction";
import router from "@ohos:router";
import { CLConfigureUtil } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import { RS_AppKey, RS_AppSecret, RS_Token_URL } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLContanst&";
import { CLToast } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLHud&";
import { CLLogManager } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCoreLog&";
import Logger from "@normalized:N&&&realauthdemo/src/main/ets/common/Logger&";
class Index extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__message = new ObservedPropertySimplePU('Hello World', this, "message");
        this.__version = new ObservedPropertySimplePU('', this, "version");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: Index_Params) {
        if (params.message !== undefined) {
            this.message = params.message;
        }
        if (params.version !== undefined) {
            this.version = params.version;
        }
    }
    updateStateVars(params: Index_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__message.purgeDependencyOnElmtId(rmElmtId);
        this.__version.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__message.aboutToBeDeleted();
        this.__version.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __message: ObservedPropertySimplePU<string>;
    get message() {
        return this.__message.get();
    }
    set message(newValue: string) {
        this.__message.set(newValue);
    }
    private __version: ObservedPropertySimplePU<string>;
    get version() {
        return this.__version.get();
    }
    set version(newValue: string) {
        this.__version.set(newValue);
    }
    instructions(image: Resource, text: string, parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.margin({ top: 10, bottom: 10 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(image);
            Image.width('20');
            Image.height('20');
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(text);
            Text.fontColor('#8A8A99');
            Text.fontSize(14);
            Text.margin({ left: 20 });
        }, Text);
        Text.pop();
        Row.pop();
    }
    async aboutToAppear(): Promise<void> {
        setTimeout(() => {
            CLLogManager.showLogView();
            CLLogManager.setLogButton();
        }, 0);
        setTimeout(() => {
            Logger.info("一条测试数据");
        }, 5000);
        CLConfigureUtil.setPrintLog(true);
        CLConfigureUtil.setAppId(RS_AppKey);
        // 1.用户服务端需要对接该接口，demo示例请求获取token
        let r: CLResponse = await CLRequest.request(RS_Token_URL, RS_AppKey, RS_AppSecret);
        // 2. 设置token
        if (r.data?.authToken) {
            CLConfigureUtil.setToken(r.data?.authToken);
            promptAction.showToast({
                message: 'token设置成功'
            });
        }
        Logger.info('请求获取token:' + JSON.stringify(r));
        Logger.info('请求获取token:' + r.data?.authToken);
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('100%');
            Column.height('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            //人像图片
            Row.create();
            //人像图片
            Row.justifyContent(FlexAlign.End);
            //人像图片
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777245, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('135');
            Image.height('170');
            Image.margin({ right: 50 });
        }, Image);
        //人像图片
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.alignItems(HorizontalAlign.Start);
            Column.margin({ left: 50 });
            Column.width('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777244, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('32');
            Image.height('23');
            Image.margin({ top: 12 });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('欢迎体验,');
            Text.fontSize(28);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ top: 20 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('创蓝实人SDK软件(v1.0.0)Demo');
            Text.fontSize(24);
            Text.fontWeight(FontWeight.Bold);
            Text.margin({ top: 15 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.height('15');
        }, Blank);
        Blank.pop();
        this.instructions.bind(this)({ "id": 16777240, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '明亮的光线环境下使用');
        this.instructions.bind(this)({ "id": 16777240, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '不要遮挡面部');
        this.instructions.bind(this)({ "id": 16777240, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, '正握手机，人脸正对屏幕');
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 20 });
            Column.alignItems(HorizontalAlign.Center);
            Column.margin({ top: 25 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('开始活体检测');
            Button.fontSize(15);
            Button.fontColor('#ffffff');
            Button.borderRadius(25);
            Button.width('320');
            Button.height('50');
            Button.linearGradient({
                colors: [
                    ['#60b1fe', 0.0],
                    ['#6551f6', 1.0]
                ]
            });
            Button.onClick(() => {
                CLToast.showLoading(this.getUIContext());
                router.pushNamedRoute({
                    name: 'CLLivingPage'
                }).then(() => {
                    CLToast.hideHud();
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('开始身份证检测');
            Button.fontSize(15);
            Button.fontColor('#ffffff');
            Button.borderRadius(25);
            Button.width('320');
            Button.height('50');
            Button.linearGradient({
                colors: [
                    ['#60b1fe', 0.0],
                    ['#6551f6', 1.0]
                ]
            });
            Button.onClick(() => {
                AppStorage.setOrCreate('cl_front_image', { "id": 16777247, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                AppStorage.setOrCreate('cl_back_image', { "id": 16777248, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
                router.pushNamedRoute({
                    name: 'CLOCRPage'
                });
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('开启日志');
            Button.fontSize(15);
            Button.fontColor('#ffffff');
            Button.borderRadius(25);
            Button.width('320');
            Button.height('50');
            Button.linearGradient({
                colors: [
                    ['#60b1fe', 0.0],
                    ['#6551f6', 1.0]
                ]
            });
            Button.onClick(() => {
                CLLogManager.showLogView();
            });
        }, Button);
        Button.pop();
        Column.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "Index";
    }
}
registerNamedRoute(() => new Index(undefined, {}), "", { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/Index", pageFullPath: "RealAuthDemo/src/main/ets/pages/Index", integratedHsp: "false", moduleType: "followWithHap" });
