if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLLivingPage_Params {
    message?: string;
}
import router from "@ohos:router";
import Logger from "@normalized:N&&&realauthdemo/src/main/ets/common/Logger&";
import { RouterPage } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
class CLLivingPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__message = new ObservedPropertySimplePU('Hello World', this, "message");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLLivingPage_Params) {
        if (params.message !== undefined) {
            this.message = params.message;
        }
    }
    updateStateVars(params: CLLivingPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__message.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__message.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __message: ObservedPropertySimplePU<string>;
    get message() {
        return this.__message.get();
    }
    set message(newValue: string) {
        this.__message.set(newValue);
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Navigation.create(new NavPathStack(), { moduleName: "RealAuthDemo", pagePath: "RealAuthDemo/src/main/ets/pages/detect/CLLivingPage", isUserCreateStack: false });
            Navigation.title('身份验证');
            Navigation.hideBackButton(false);
            Navigation.titleMode(NavigationTitleMode.Mini);
        }, Navigation);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.alignItems(HorizontalAlign.Center);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('拍摄您本人人脸，请保证正对手机，光线充足');
            Text.fontWeight(FontWeight.Bold);
            Text.fontSize(16);
            Text.fontColor('#000000');
            Text.margin({ top: 30 });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777263, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('169');
            Image.height('169');
            Image.margin({ top: 25 });
        }, Image);
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.margin({ top: 60, left: 30, right: 30 });
            Column.alignItems(HorizontalAlign.Start);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('1.请确认由本人亲自操作 \n2.请将脸置于提示框中，并按提示完成动作');
            Text.fontSize(16);
            Text.fontWeight(FontWeight.Regular);
            Text.fontColor('#000000');
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.justifyContent(FlexAlign.SpaceBetween);
            Row.alignItems(VerticalAlign.Top);
            Row.width('100%');
            Row.padding({ left: 30, right: 30 });
            Row.margin({ top: 36 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777264, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('56');
            Image.height('56');
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('不能遮挡脸部');
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777265, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('56');
            Image.height('56');
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('不能在昏暗\n逆光下拍摄');
        }, Text);
        Text.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777266, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width('56');
            Image.height('56');
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('不能斜视手机');
        }, Text);
        Text.pop();
        Column.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.padding({ left: 20, right: 20 });
            Row.margin({ top: 45 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('采集本人人脸');
            Button.fontSize(18);
            Button.fontColor('#ffffff');
            Button.backgroundColor('#60b1fe');
            Button.width('100%');
            Button.height('50');
            Button.onClick(() => {
                Logger.info('开始进行活体检测');
                router.pushNamedRoute({
                    name: RouterPage.LivingVideoPage
                });
            });
        }, Button);
        Button.pop();
        Row.pop();
        Column.pop();
        Navigation.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLLivingPage";
    }
}
{
    let routeNameNode = 'CLLivingPage';
    registerNamedRoute(() => new CLLivingPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/detect/CLLivingPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/detect/CLLivingPage", integratedHsp: "false", moduleType: "followWithHap" });
}
