if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCREditPage_Params {
    imageScale?: number;
    pinchValue?: number;
    pinchX?: number;
    pinchY?: number;
    pointX?: number;
    pointY?: number;
    offsetX?: number;
    offsetY?: number;
    imagePixelMap?: PixelMap | undefined;
    originalPixelMap?: PixelMap | undefined;
    isShow?: boolean;
    clipX?: number;
    clipY?: number;
    clipWidth?: number;
    clipHeight?: number;
    settings?: RenderingContextSettings;
    context?: CanvasRenderingContext2D;
    holeRadius?: number;
    centerX?: number;
    centerY?: number;
    maskWidth?: number;
    maskHeight?: number;
    screenWidth?: number;
    screenHeight?: number;
    cropSize?: number;
}
import image from "@ohos:multimedia.image";
import display from "@ohos:display";
import type { BusinessError as BusinessError } from "@ohos:base";
import router from "@ohos:router";
interface CropAreaSize {
    width: number;
    height: number;
}
interface CropArea {
    x: number;
    y: number;
    size: CropAreaSize;
}
class CLOCREditPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__imageScale = new ObservedPropertySimplePU(1, this, "imageScale");
        this.__pinchValue = new ObservedPropertySimplePU(1, this, "pinchValue");
        this.__pinchX = new ObservedPropertySimplePU(0, this, "pinchX");
        this.__pinchY = new ObservedPropertySimplePU(0, this, "pinchY");
        this.__pointX = new ObservedPropertySimplePU(0, this, "pointX");
        this.__pointY = new ObservedPropertySimplePU(0, this, "pointY");
        this.__offsetX = new ObservedPropertySimplePU(0, this, "offsetX");
        this.__offsetY = new ObservedPropertySimplePU(0, this, "offsetY");
        this.__imagePixelMap = new ObservedPropertyObjectPU(undefined, this, "imagePixelMap");
        this.__originalPixelMap = new ObservedPropertyObjectPU(undefined, this, "originalPixelMap");
        this.__isShow = new ObservedPropertySimplePU(false, this, "isShow");
        this.clipX = 200 // 裁剪框在屏幕上的起始x坐标（单位px）
        ;
        this.clipY = 300 // 裁剪框在屏幕上的起始y坐标
        ;
        this.clipWidth = 300 // 裁剪框宽
        ;
        this.clipHeight = 200 // 裁剪框高
        ;
        this.settings = new RenderingContextSettings(true);
        this.context = new CanvasRenderingContext2D(this.settings);
        this.holeRadius = 100;
        this.centerX = 360;
        this.centerY = 720;
        this.maskWidth = 300;
        this.maskHeight = 300;
        this.screenWidth = 0;
        this.screenHeight = 0;
        this.cropSize = 300;
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCREditPage_Params) {
        if (params.imageScale !== undefined) {
            this.imageScale = params.imageScale;
        }
        if (params.pinchValue !== undefined) {
            this.pinchValue = params.pinchValue;
        }
        if (params.pinchX !== undefined) {
            this.pinchX = params.pinchX;
        }
        if (params.pinchY !== undefined) {
            this.pinchY = params.pinchY;
        }
        if (params.pointX !== undefined) {
            this.pointX = params.pointX;
        }
        if (params.pointY !== undefined) {
            this.pointY = params.pointY;
        }
        if (params.offsetX !== undefined) {
            this.offsetX = params.offsetX;
        }
        if (params.offsetY !== undefined) {
            this.offsetY = params.offsetY;
        }
        if (params.imagePixelMap !== undefined) {
            this.imagePixelMap = params.imagePixelMap;
        }
        if (params.originalPixelMap !== undefined) {
            this.originalPixelMap = params.originalPixelMap;
        }
        if (params.isShow !== undefined) {
            this.isShow = params.isShow;
        }
        if (params.clipX !== undefined) {
            this.clipX = params.clipX;
        }
        if (params.clipY !== undefined) {
            this.clipY = params.clipY;
        }
        if (params.clipWidth !== undefined) {
            this.clipWidth = params.clipWidth;
        }
        if (params.clipHeight !== undefined) {
            this.clipHeight = params.clipHeight;
        }
        if (params.settings !== undefined) {
            this.settings = params.settings;
        }
        if (params.context !== undefined) {
            this.context = params.context;
        }
        if (params.holeRadius !== undefined) {
            this.holeRadius = params.holeRadius;
        }
        if (params.centerX !== undefined) {
            this.centerX = params.centerX;
        }
        if (params.centerY !== undefined) {
            this.centerY = params.centerY;
        }
        if (params.maskWidth !== undefined) {
            this.maskWidth = params.maskWidth;
        }
        if (params.maskHeight !== undefined) {
            this.maskHeight = params.maskHeight;
        }
        if (params.screenWidth !== undefined) {
            this.screenWidth = params.screenWidth;
        }
        if (params.screenHeight !== undefined) {
            this.screenHeight = params.screenHeight;
        }
        if (params.cropSize !== undefined) {
            this.cropSize = params.cropSize;
        }
    }
    updateStateVars(params: CLOCREditPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__imageScale.purgeDependencyOnElmtId(rmElmtId);
        this.__pinchValue.purgeDependencyOnElmtId(rmElmtId);
        this.__pinchX.purgeDependencyOnElmtId(rmElmtId);
        this.__pinchY.purgeDependencyOnElmtId(rmElmtId);
        this.__pointX.purgeDependencyOnElmtId(rmElmtId);
        this.__pointY.purgeDependencyOnElmtId(rmElmtId);
        this.__offsetX.purgeDependencyOnElmtId(rmElmtId);
        this.__offsetY.purgeDependencyOnElmtId(rmElmtId);
        this.__imagePixelMap.purgeDependencyOnElmtId(rmElmtId);
        this.__originalPixelMap.purgeDependencyOnElmtId(rmElmtId);
        this.__isShow.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__imageScale.aboutToBeDeleted();
        this.__pinchValue.aboutToBeDeleted();
        this.__pinchX.aboutToBeDeleted();
        this.__pinchY.aboutToBeDeleted();
        this.__pointX.aboutToBeDeleted();
        this.__pointY.aboutToBeDeleted();
        this.__offsetX.aboutToBeDeleted();
        this.__offsetY.aboutToBeDeleted();
        this.__imagePixelMap.aboutToBeDeleted();
        this.__originalPixelMap.aboutToBeDeleted();
        this.__isShow.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __imageScale: ObservedPropertySimplePU<number>;
    get imageScale() {
        return this.__imageScale.get();
    }
    set imageScale(newValue: number) {
        this.__imageScale.set(newValue);
    }
    private __pinchValue: ObservedPropertySimplePU<number>;
    get pinchValue() {
        return this.__pinchValue.get();
    }
    set pinchValue(newValue: number) {
        this.__pinchValue.set(newValue);
    }
    private __pinchX: ObservedPropertySimplePU<number>;
    get pinchX() {
        return this.__pinchX.get();
    }
    set pinchX(newValue: number) {
        this.__pinchX.set(newValue);
    }
    private __pinchY: ObservedPropertySimplePU<number>;
    get pinchY() {
        return this.__pinchY.get();
    }
    set pinchY(newValue: number) {
        this.__pinchY.set(newValue);
    }
    private __pointX: ObservedPropertySimplePU<number>;
    get pointX() {
        return this.__pointX.get();
    }
    set pointX(newValue: number) {
        this.__pointX.set(newValue);
    }
    private __pointY: ObservedPropertySimplePU<number>;
    get pointY() {
        return this.__pointY.get();
    }
    set pointY(newValue: number) {
        this.__pointY.set(newValue);
    }
    private __offsetX: ObservedPropertySimplePU<number>;
    get offsetX() {
        return this.__offsetX.get();
    }
    set offsetX(newValue: number) {
        this.__offsetX.set(newValue);
    }
    private __offsetY: ObservedPropertySimplePU<number>;
    get offsetY() {
        return this.__offsetY.get();
    }
    set offsetY(newValue: number) {
        this.__offsetY.set(newValue);
    }
    private __imagePixelMap: ObservedPropertyObjectPU<PixelMap | undefined>;
    get imagePixelMap() {
        return this.__imagePixelMap.get();
    }
    set imagePixelMap(newValue: PixelMap | undefined) {
        this.__imagePixelMap.set(newValue);
    }
    private __originalPixelMap: ObservedPropertyObjectPU<PixelMap | undefined>;
    get originalPixelMap() {
        return this.__originalPixelMap.get();
    }
    set originalPixelMap(newValue: PixelMap | undefined) {
        this.__originalPixelMap.set(newValue);
    }
    private __isShow: ObservedPropertySimplePU<boolean>;
    get isShow() {
        return this.__isShow.get();
    }
    set isShow(newValue: boolean) {
        this.__isShow.set(newValue);
    }
    private clipX: number; // 裁剪框在屏幕上的起始x坐标（单位px）
    private clipY: number; // 裁剪框在屏幕上的起始y坐标
    private clipWidth: number; // 裁剪框宽
    private clipHeight: number; // 裁剪框高
    private settings: RenderingContextSettings;
    private context: CanvasRenderingContext2D;
    private holeRadius: number;
    private centerX: number;
    private centerY: number;
    private maskWidth: number;
    private maskHeight: number;
    private screenWidth: number;
    private screenHeight: number;
    private cropSize: number;
    aboutToAppear(): void {
        let displayInfo = display.getDefaultDisplaySync();
        let density = displayInfo.scaledDensity;
        this.screenWidth = display.getDefaultDisplaySync().width / density;
        this.screenHeight = display.getDefaultDisplaySync().height / density;
        this.clipX = this.screenWidth / 2 - 150;
        this.clipY = 200;
        this.clipWidth = 300;
        this.clipHeight = 200;
    }
    private drawClipMask(ctx: CanvasRenderingContext2D) {
        ctx.fillStyle = 'rgba(0, 0, 0, 0.5)';
        ctx.fillRect(0, 0, this.screenWidth, 600);
        ctx.clearRect((this.screenWidth - this.clipWidth) / 2, (600 - this.clipHeight) / 2, this.clipWidth, this.clipHeight);
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 2;
        ctx.strokeRect((this.screenWidth - this.clipWidth) / 2, (600 - this.clipHeight) / 2, this.clipWidth, this.clipHeight);
    }
    async getPixelMap() {
        const context = getContext(this);
        const resourceMgr = context.resourceManager;
        const fileData = await resourceMgr.getMediaContent({ "id": 16777238, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
        const buffer = fileData.buffer;
        const imageSource = image.createImageSource(buffer);
        const pixelMap = await imageSource.createPixelMap();
        this.originalPixelMap = pixelMap;
        this.imagePixelMap = pixelMap;
        // this.imagePixelMap.scaleSync(0.3,0.3)
    }
    async copyPixelMap(pm: PixelMap): Promise<PixelMap> {
        const imageInfo: image.ImageInfo = await pm.getImageInfo();
        const buffer: ArrayBuffer = new ArrayBuffer(pm.getPixelBytesNumber());
        await pm.readPixelsToBuffer(buffer);
        const opts: image.InitializationOptions = {
            editable: true,
            pixelFormat: image.PixelMapFormat.RGBA_8888,
            size: { height: imageInfo.size.height, width: imageInfo.size.width }
        };
        return image.createPixelMap(buffer, opts);
    }
    async cropImage() {
        console.log('裁剪开始');
        console.log(`获取裁剪之前信息：${this.imagePixelMap?.getImageInfoSync().size.height} ${this.imagePixelMap?.getImageInfoSync().size.width}`);
        if (!this.imagePixelMap) {
            return;
        }
        const pixelMapTemp = await this.copyPixelMap(this.imagePixelMap);
        const imageInfo = this.imagePixelMap.getImageInfoSync();
        const originalWidth = imageInfo.size.width;
        const originalHeight = imageInfo.size.height;
        const scale = this.imageScale;
        const translateX = this.offsetX;
        const translateY = this.offsetY;
        const clipX = (this.screenWidth - this.clipWidth) / 2;
        const clipY = (600 - this.clipHeight) / 2;
        const srcX = Math.round((clipX - translateX) / this.imageScale);
        const srcY = Math.round((clipY - translateY) / this.imageScale);
        const srcWidth = Math.round(this.clipWidth / this.imageScale);
        const srcHeight = Math.round(this.clipHeight / this.imageScale);
        try {
            await pixelMapTemp?.crop({
                x: srcX,
                y: srcY,
                size: {
                    width: srcWidth,
                    height: srcHeight,
                }
            });
            this.isShow = true;
            console.log('裁剪完成');
            console.log(`获取裁剪之后信息：${pixelMapTemp?.getImageInfoSync().size.height} ${pixelMapTemp?.getImageInfoSync().size.width}`);
            this.imagePixelMap = pixelMapTemp;
        }
        catch (err) {
            let error = err as BusinessError;
            console.error('裁剪失败:', error.code, error.message);
        }
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('100%');
            Column.height('100%');
            Column.onAppear(() => {
                this.getPixelMap();
                // this.imagePixelMap?.scaleSync(2,2)
            });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create();
            Stack.height(600);
            Stack.backgroundColor('#00000000');
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            // 背景图 + 手势
            if (this.imagePixelMap) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Stack.create({ alignContent: Alignment.Center });
                        Stack.onClick(() => {
                            console.log('点击了');
                        });
                        Gesture.create(GesturePriority.Low);
                        PanGesture.create();
                        PanGesture.onActionUpdate((event: GestureEvent) => {
                            this.offsetX = this.pointX + event.offsetX;
                            this.offsetY = this.pointY + event.offsetY;
                            console.log('拖动' + this.offsetX + '-' + this.offsetY);
                        });
                        PanGesture.onActionEnd(() => {
                            this.pointX = this.offsetX;
                            this.pointY = this.offsetY;
                        });
                        PanGesture.pop();
                        Gesture.pop();
                        Gesture.create(GesturePriority.Low);
                        PinchGesture.create();
                        PinchGesture.onActionStart((event: GestureEvent) => {
                            console.info('Pinch start');
                        });
                        PinchGesture.onActionUpdate((event: GestureEvent) => {
                            this.imageScale = this.pinchValue * event.scale;
                            this.pinchX = event.pinchCenterX;
                            this.pinchY = event.pinchCenterY;
                        });
                        PinchGesture.onActionEnd(() => {
                            this.pinchValue = this.imageScale;
                            console.log(`输出缩放后的image：${this.imageScale}`);
                        });
                        PinchGesture.pop();
                        Gesture.pop();
                    }, Stack);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Row.create();
                        Row.width('100%');
                        Row.justifyContent(FlexAlign.Center);
                        Row.position({ top: 40 });
                    }, Row);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Text.create('适当调整方向，将图片置于虚线框内');
                        Text.fontColor('#FFFFFF');
                        Text.fontSize(14);
                        Text.textAlign(TextAlign.Center);
                        Text.borderRadius(2);
                        Text.backgroundColor('#515459');
                        Text.padding(5);
                    }, Text);
                    Text.pop();
                    Row.pop();
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        // 图片内容
                        Image.create(this.imagePixelMap);
                        // 图片内容
                        Image.scale({ x: this.imageScale, y: this.imageScale });
                        // 图片内容
                        Image.translate({ x: this.offsetX, y: this.offsetY });
                        // 图片内容
                        Image.objectFit(ImageFit.CENTER);
                    }, Image);
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Canvas.create(this.context);
                        Canvas.width('100%');
                        Canvas.height('100%');
                        Canvas.backgroundColor(undefined);
                        Canvas.onReady(() => {
                            this.context.fillStyle = 'rgba(0, 0, 0, 0.3)';
                            // 绘制覆盖整个 Canvas 的矩形
                            this.context.fillRect(0, 0, this.screenWidth, 600);
                            // 在矩形中心位置创建镂空区域
                            this.context.clearRect(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
                        });
                    }, Canvas);
                    Canvas.pop();
                    Stack.pop();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                });
            }
        }, If);
        If.pop();
        Stack.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            // 操作按钮
            Row.create();
            // 操作按钮
            Row.justifyContent(FlexAlign.SpaceBetween);
            // 操作按钮
            Row.margin({ top: 40 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (this.isShow) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.observeComponentCreation2((elmtId, isInitialRender) => {
                        Image.create(this.imagePixelMap);
                        Image.width('80');
                        Image.height('60');
                    }, Image);
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                });
            }
        }, If);
        If.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('取消');
            Button.fontColor('#FFFFFF');
            Button.fontSize(16);
            Button.type(ButtonType.Normal);
            Button.onClick(() => {
                router.back();
            });
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel();
            Button.backgroundImage({ "id": 16777259, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Button.backgroundImagePosition(Alignment.Center);
            Button.width('44');
            Button.aspectRatio(1);
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel();
            Button.backgroundImage({ "id": 16777270, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Button.backgroundImagePosition(Alignment.Center);
            Button.width('44');
            Button.aspectRatio(1);
        }, Button);
        Button.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('确定');
            Button.fontColor('#FFFFFF');
            Button.fontSize(16);
            Button.type(ButtonType.Normal);
            Button.onClick(() => {
                this.cropImage();
                // router.back()
            });
        }, Button);
        Button.pop();
        // 操作按钮
        Row.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCREditPage";
    }
}
{
    let routeNameNode = 'CLOCREditPage';
    registerNamedRoute(() => new CLOCREditPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCREditPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCREditPage", integratedHsp: "false", moduleType: "followWithHap" });
}
