if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCREditPage1_Params {
    src?: string;
    quality?: number;
    controller?: CropController;
    cardType?: number;
    isBack?: boolean;
    rxResult?: ESObject;
    ghResult?: ESObject;
}
import { CropView, CropController } from "@normalized:N&&&realauthdemo/src/main/ets/common/CropView&";
import "@normalized:N&&&realauthdemo/src/main/ets/pages/ocr/CLOCRUploadCardPage&";
import router from "@ohos:router";
import image from "@ohos:multimedia.image";
import type { OCREditParam } from '../CLParams';
import { CLCommon } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLCommon&";
export class CLOCREditPage1 extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.src = '';
        this.quality = 90;
        this.controller = new CropController();
        this.__cardType = new ObservedPropertySimplePU(0, this, "cardType");
        this.__isBack = new ObservedPropertySimplePU(false, this, "isBack");
        this.rxResult = undefined;
        this.ghResult = undefined;
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCREditPage1_Params) {
        if (params.src !== undefined) {
            this.src = params.src;
        }
        if (params.quality !== undefined) {
            this.quality = params.quality;
        }
        if (params.controller !== undefined) {
            this.controller = params.controller;
        }
        if (params.cardType !== undefined) {
            this.cardType = params.cardType;
        }
        if (params.isBack !== undefined) {
            this.isBack = params.isBack;
        }
        if (params.rxResult !== undefined) {
            this.rxResult = params.rxResult;
        }
        if (params.ghResult !== undefined) {
            this.ghResult = params.ghResult;
        }
    }
    updateStateVars(params: CLOCREditPage1_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__cardType.purgeDependencyOnElmtId(rmElmtId);
        this.__isBack.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__cardType.aboutToBeDeleted();
        this.__isBack.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private src: string;
    private quality: number;
    private controller: CropController;
    private __cardType: ObservedPropertySimplePU<number>;
    get cardType() {
        return this.__cardType.get();
    }
    set cardType(newValue: number) {
        this.__cardType.set(newValue);
    }
    private __isBack: ObservedPropertySimplePU<boolean>;
    get isBack() {
        return this.__isBack.get();
    }
    set isBack(newValue: boolean) {
        this.__isBack.set(newValue);
    }
    private rxResult: any;
    private ghResult: any;
    async getPixelMap(res: Resource) {
        const context = getContext(this);
        const resourceMgr = context.resourceManager;
        const fileData = await resourceMgr.getMediaContent(res);
        const buffer = fileData.buffer;
        const imageSource = image.createImageSource(buffer);
        const pixelMap = await imageSource.createPixelMap();
        return pixelMap;
    }
    aboutToAppear(): void {
        const params = this.getUIContext().getRouter().getParams() as OCREditParam;
        this.src = params.imagePath;
        this.cardType = params.cardType;
        this.isBack = params.isBack;
        this.rxResult = params.rxResult;
        this.ghResult = params.ghResult;
        console.log('🔥输出当前的CLOCREditPage1：' + JSON.stringify(params));
    }
    imageBuilder(rx: boolean, parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            If.create();
            if (rx) {
                this.ifElseBranchUpdateFunction(0, () => {
                    this.imageRXBuilder.bind(this)();
                });
            }
            else {
                this.ifElseBranchUpdateFunction(1, () => {
                    this.imageGHBuilder.bind(this)();
                });
            }
        }, If);
        If.pop();
    }
    imageRXBuilder(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width(300);
            Column.aspectRatio(1.6);
            Column.justifyContent(FlexAlign.Start);
            Column.alignItems(HorizontalAlign.End);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777271, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width(100);
            Image.aspectRatio(0.8);
            Image.margin({ top: '12%', right: '10%' });
        }, Image);
        Column.pop();
    }
    imageGHBuilder(parent = null) {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width(300);
            Column.aspectRatio(1.6);
            Column.justifyContent(FlexAlign.Start);
            Column.alignItems(HorizontalAlign.Start);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create({ "id": 16777251, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" });
            Image.width(60);
            Image.aspectRatio(1);
            Image.margin({ top: '7%', left: '10%' });
        }, Image);
        Column.pop();
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create({ alignContent: Alignment.Top });
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Stack.create({ alignContent: Alignment.Bottom });
        }, Stack);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            __Common__.create();
            __Common__.width('100%');
            __Common__.height('100%');
        }, __Common__);
        {
            this.observeComponentCreation2((elmtId, isInitialRender) => {
                if (isInitialRender) {
                    let componentCall = new CropView(this, {
                        src: this.src,
                        controller: this.controller,
                        maskColor: '#B32C2C2C',
                        frameWidth: 300,
                        frameRatio: 1.6,
                        customBuilder: (this.cardType === 1 ? this.imageGHBuilder : this.imageRXBuilder)
                    }, undefined, elmtId, () => { }, { page: "RealAuthDemo/src/main/ets/pages/ocr/CLOCREditPage1.ets", line: 86, col: 9 });
                    ViewV2.create(componentCall);
                    let paramsLambda = () => {
                        return {
                            src: this.src,
                            controller: this.controller,
                            maskColor: '#B32C2C2C',
                            frameWidth: 300,
                            frameRatio: 1.6,
                            customBuilder: (this.cardType === 1 ? this.imageGHBuilder : this.imageRXBuilder)
                        };
                    };
                    componentCall.paramsGenerator_ = paramsLambda;
                }
                else {
                    this.updateStateVarsOfChildByElmtId(elmtId, {
                        src: this.src,
                        controller: this.controller,
                        maskColor: '#B32C2C2C',
                        frameWidth: 300,
                        frameRatio: 1.6
                    });
                }
            }, { name: "CropView" });
        }
        __Common__.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create({ space: 20 });
            Row.alignItems(VerticalAlign.Center);
            Row.padding({ top: 12, bottom: 30 });
            Row.width('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.layoutWeight(1);
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('取消');
            Text.constraintSize({ minWidth: 48 });
            Text.fontColor('#ffffff');
            Text.onClick(() => { router.back(); });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('旋转');
            Text.constraintSize({ minWidth: 48 });
            Text.fontColor('#ffffff');
            Text.onClick(() => {
                this.controller.rotate();
            });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('灰度');
            Text.constraintSize({ minWidth: 48 });
            Text.fontColor('#ffffff');
            Text.onClick(() => {
                this.controller.grayscale(!this.controller.isGrayscale());
            });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('确定');
            Text.constraintSize({ minWidth: 48 });
            Text.fontColor('#ffffff');
            Text.onClick(() => {
                this.controller.cropWithPath({ format: 'image/png', quality: this.quality })
                    .then(async (path) => {
                    console.log('编辑后的图片路径：' + path);
                    if (this.isBack) {
                        if (this.cardType === 0) {
                            AppStorage.setOrCreate('cl_front_image', await CLCommon.loadTempImageAndShow(path));
                        }
                        else if (this.cardType === 1) {
                            AppStorage.setOrCreate('cl_back_image', await CLCommon.loadTempImageAndShow(path));
                        }
                        router.back(2);
                    }
                    else {
                        router.pushNamedRoute({
                            name: 'CLOCRUploadCardPage',
                            params: {
                                imagePath: path,
                                cardType: this.cardType,
                                rxResult: this.rxResult,
                                ghResult: this.ghResult
                            }
                        });
                    }
                });
            });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
            Blank.layoutWeight(1);
        }, Blank);
        Blank.pop();
        Row.pop();
        Stack.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.justifyContent(FlexAlign.Center);
            Row.position({ top: 40 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('适当调整方向，将图片置于虚线框内');
            Text.fontColor('#FFFFFF');
            Text.fontSize(14);
            Text.textAlign(TextAlign.Center);
            Text.borderRadius(2);
            Text.backgroundColor('#515459');
            Text.padding(5);
        }, Text);
        Text.pop();
        Row.pop();
        Stack.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCREditPage1";
    }
}
{
    let routeNameNode = 'CLOCREditPage1';
    registerNamedRoute(() => new CLOCREditPage1(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCREditPage1", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCREditPage1", integratedHsp: "false", moduleType: "followWithHap" });
}
