if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCRResultPage_Params {
    result?: boolean;
    imageResource?: Resource;
    resultString?: string;
    buttonTitleString?: string;
}
import type { OCRResultParam } from '../CLParams';
import router from "@ohos:router";
import type { CLResult, CLOCRAuthOrderMessage } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
export class CLOCRResultPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__result = new ObservedPropertySimplePU(true, this, "result");
        this.__imageResource = new ObservedPropertyObjectPU({ "id": 16777275, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" }, this, "imageResource");
        this.__resultString = new ObservedPropertySimplePU('认证成功！', this, "resultString");
        this.__buttonTitleString = new ObservedPropertySimplePU('回首页', this, "buttonTitleString");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCRResultPage_Params) {
        if (params.result !== undefined) {
            this.result = params.result;
        }
        if (params.imageResource !== undefined) {
            this.imageResource = params.imageResource;
        }
        if (params.resultString !== undefined) {
            this.resultString = params.resultString;
        }
        if (params.buttonTitleString !== undefined) {
            this.buttonTitleString = params.buttonTitleString;
        }
    }
    updateStateVars(params: CLOCRResultPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__result.purgeDependencyOnElmtId(rmElmtId);
        this.__imageResource.purgeDependencyOnElmtId(rmElmtId);
        this.__resultString.purgeDependencyOnElmtId(rmElmtId);
        this.__buttonTitleString.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__result.aboutToBeDeleted();
        this.__imageResource.aboutToBeDeleted();
        this.__resultString.aboutToBeDeleted();
        this.__buttonTitleString.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __result: ObservedPropertySimplePU<boolean>;
    get result() {
        return this.__result.get();
    }
    set result(newValue: boolean) {
        this.__result.set(newValue);
    }
    private __imageResource: ObservedPropertyObjectPU<Resource>;
    get imageResource() {
        return this.__imageResource.get();
    }
    set imageResource(newValue: Resource) {
        this.__imageResource.set(newValue);
    }
    private __resultString: ObservedPropertySimplePU<string>;
    get resultString() {
        return this.__resultString.get();
    }
    set resultString(newValue: string) {
        this.__resultString.set(newValue);
    }
    private __buttonTitleString: ObservedPropertySimplePU<string>;
    get buttonTitleString() {
        return this.__buttonTitleString.get();
    }
    set buttonTitleString(newValue: string) {
        this.__buttonTitleString.set(newValue);
    }
    aboutToAppear(): void {
        const param = this.getUIContext().getRouter().getParams() as OCRResultParam;
        const response = param.response as CLResult<CLOCRAuthOrderMessage>;
        if (response.code === '000000') {
            this.result = true;
        }
        else {
            this.result = false;
        }
        if (this.result === false) {
            this.imageResource = { "id": 16777250, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" };
            this.resultString = response.message ?? '身份证与姓名不匹配';
            this.buttonTitleString = '重新认证';
        }
        else {
            this.imageResource = { "id": 16777275, "type": 20000, params: [], "bundleName": "com.example.realauth", "moduleName": "RealAuthDemo" };
            this.resultString = '认证成功！';
        }
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('100%');
            Column.height('100%');
            Column.alignItems(HorizontalAlign.Center);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.imageResource);
            Image.width('142');
            Image.height('118');
            Image.margin({ top: 120 });
        }, Image);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.resultString);
            Text.margin({ top: 20 });
            Text.fontSize(24);
            Text.fontColor('#606581');
            Text.fontWeight(FontWeight.Bold);
            Text.textAlign(TextAlign.Center);
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.buttonTitleString);
            Button.fontColor('#ffffff');
            Button.fontSize(17);
            Button.backgroundColor('#3f75fc');
            Button.borderRadius(5);
            Button.width('80%');
            Button.margin({ top: 57 });
            Button.onClick(() => {
                if (this.result) {
                    router.back(1);
                }
                else {
                    router.back();
                }
            });
        }, Button);
        Button.pop();
        Column.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCRResultPage";
    }
}
{
    let routeNameNode = 'CLOCRResultPage';
    registerNamedRoute(() => new CLOCRResultPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCRResultPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRResultPage", integratedHsp: "false", moduleType: "followWithHap" });
}
