if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface CLOCRSubmitPage_Params {
    cardName?: string;
    cardNum?: string;
    rxImagePixMap?: image.PixelMap | undefined;
    ghImagePixMap?: image.PixelMap | undefined;
}
import { RouterPage } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import type { OCRSubmitParam } from "@normalized:N&&&realauthdemo/src/main/ets/pages/CLParams&";
import type image from "@ohos:multimedia.image";
import { CLOCRManager } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import type { CLResult, CLOCRAuthOrderMessage, CLOCRCardMessage } from "@normalized:N&&&@wanshu/realauthsdk/Index&1.0.0";
import router from "@ohos:router";
import { CLToast } from "@normalized:N&&&realauthdemo/src/main/ets/common/CLHud&";
export class CLOCRSubmitPage extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__cardName = new ObservedPropertySimplePU('', this, "cardName");
        this.__cardNum = new ObservedPropertySimplePU('', this, "cardNum");
        this.__rxImagePixMap = this.createStorageLink('rxImagePixMap', undefined, "rxImagePixMap");
        this.__ghImagePixMap = this.createStorageLink('ghImagePixMap', undefined, "ghImagePixMap");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: CLOCRSubmitPage_Params) {
        if (params.cardName !== undefined) {
            this.cardName = params.cardName;
        }
        if (params.cardNum !== undefined) {
            this.cardNum = params.cardNum;
        }
    }
    updateStateVars(params: CLOCRSubmitPage_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__cardName.purgeDependencyOnElmtId(rmElmtId);
        this.__cardNum.purgeDependencyOnElmtId(rmElmtId);
        this.__rxImagePixMap.purgeDependencyOnElmtId(rmElmtId);
        this.__ghImagePixMap.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__cardName.aboutToBeDeleted();
        this.__cardNum.aboutToBeDeleted();
        this.__rxImagePixMap.aboutToBeDeleted();
        this.__ghImagePixMap.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __cardName: ObservedPropertySimplePU<string>;
    get cardName() {
        return this.__cardName.get();
    }
    set cardName(newValue: string) {
        this.__cardName.set(newValue);
    }
    private __cardNum: ObservedPropertySimplePU<string>;
    get cardNum() {
        return this.__cardNum.get();
    }
    set cardNum(newValue: string) {
        this.__cardNum.set(newValue);
    }
    private __rxImagePixMap: ObservedPropertyAbstractPU<image.PixelMap | undefined>;
    get rxImagePixMap() {
        return this.__rxImagePixMap.get();
    }
    set rxImagePixMap(newValue: image.PixelMap | undefined) {
        this.__rxImagePixMap.set(newValue);
    }
    private __ghImagePixMap: ObservedPropertyAbstractPU<image.PixelMap | undefined>;
    get ghImagePixMap() {
        return this.__ghImagePixMap.get();
    }
    set ghImagePixMap(newValue: image.PixelMap | undefined) {
        this.__ghImagePixMap.set(newValue);
    }
    aboutToAppear(): void {
        const param = this.getUIContext().getRouter().getParams() as OCRSubmitParam;
        const rxResult = param.rxResult as CLResult<CLOCRCardMessage>;
        const ghResult = param.ghResult as CLResult<CLOCRCardMessage>;
        console.log('人像信息：' + JSON.stringify(rxResult));
        console.log('国徽信息：' + JSON.stringify(ghResult));
        this.cardName = rxResult.data.name;
        this.cardNum = rxResult.data.id_card_no;
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Navigation.create(new NavPathStack(), { moduleName: "RealAuthDemo", pagePath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRSubmitPage", isUserCreateStack: false });
            Navigation.title('识别结果');
            Navigation.titleMode(NavigationTitleMode.Mini);
        }, Navigation);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.alignItems(HorizontalAlign.Center);
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('80%');
            Row.justifyContent(FlexAlign.Center);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Image.create(this.rxImagePixMap);
            Image.width('300');
            Image.aspectRatio(1.6);
        }, Image);
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create({ space: 15 });
            Column.width('100%');
            Column.alignItems(HorizontalAlign.Start);
            Column.margin({ top: 20 });
            Column.padding({ left: 20, right: 20 });
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create({ space: 15 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('姓名  ');
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.cardName);
        }, Text);
        Text.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create({ space: 15 });
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create('身份证 ');
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.cardNum);
        }, Text);
        Text.pop();
        Row.pop();
        Column.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.justifyContent(FlexAlign.Center);
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('提交认证');
            Button.width('80%');
            Button.height('44');
            Button.margin({ top: 30 });
            Button.onClick(async () => {
                CLToast.showLoading(this.getUIContext());
                // 提交认证
                let result = await CLOCRManager.realPersonDetect(this.cardName, this.cardNum) as CLResult<CLOCRAuthOrderMessage>;
                if (result.code != '000000') {
                    CLToast.hideHud();
                    CLToast.showMessage(this.getUIContext(), result.message);
                    return;
                }
                router.pushNamedRoute({
                    name: RouterPage.OCRResultPage,
                    params: {
                        response: result
                    }
                }).then(() => {
                    CLToast.hideHud();
                });
                console.log('认证结果：' + JSON.stringify(result));
            });
        }, Button);
        Button.pop();
        Row.pop();
        Column.pop();
        Navigation.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "CLOCRSubmitPage";
    }
}
{
    let routeNameNode = 'CLOCRSubmitPage';
    registerNamedRoute(() => new CLOCRSubmitPage(undefined, {}), routeNameNode, { bundleName: "com.example.realauth", moduleName: "RealAuthDemo", pagePath: "pages/ocr/CLOCRSubmitPage", pageFullPath: "RealAuthDemo/src/main/ets/pages/ocr/CLOCRSubmitPage", integratedHsp: "false", moduleType: "followWithHap" });
}
